package com.sap.cds.repackaged.audit.api.v2;

/**
 * The data object is the object where the personal data whose access/modification is being audited is contained.
 * The object logged should look similar to:
 * <pre>
 * {
 *    "type": "testType",
 *    "id": {
 *      "key1": "value1",
 *      "key2": "value2"
 *    }
 * }</pre>, providing more detailed information on the type of the object where the changed configuration is located and
 * information on the key identifiers that identify the object.
 **/
public interface AuditedObject {
	
	/**
	 * Adds type to the data object.
	 * 
	 * @param type Type of the data object.
	 */
	public void setType(String type);
	
	/**
	 * Adds identifier to the data object.
	 * 
	 * @param key The key of the identifier.
	 * @param value The value of the identifier.
	 */
	public void addIdentifier(String key, String value);

}
