package com.sap.cds.repackaged.audit.api.v2;

import com.sap.cds.repackaged.audit.api.TransactionalAuditLogMessage;

/**
 * The configuration change interface allows the logging of changes to any configuration data.
 * The log message should reflect which configuration data have been changed.
 */
public interface ConfigurationChangeAuditMessage extends TransactionalAuditLogMessage {
	
	/**
	 * Sets the audited object where the modified personal data is contained.
	 * 
	 * @param object The object where the modified personal data that is being audit logged is contained.
	 */
	void setObject(AuditedObject object);
	
	/**
	 * Adds new value to an already existing key and value pair from the modified data set.
	 * 
	 * @param key Data set key
	 * @param oldValue The old key value of the modified data set. Must be <code>null</code> for a new data set key.
	 * @param newValue The new key value of the modified data set. Must be <code>null</code> for a deleted data set key.
	 */
	void addValue(String key, String oldValue, String newValue);

}
