package com.sap.cds.repackaged.audit.api.v2;

import com.sap.cds.repackaged.audit.api.TransactionalAuditLogMessage;

/**
 * Data modification interface for logging successful and unsuccessful modification to any sensitive personal data.
 * Logging shall be done where data is disclosed to a user or a third party.
 * 
 * Examples of such personal data includes: information on racial or ethnic origin, political opinions, religious or philosophical 
 * beliefs, trade-union membership, health or sex life, bank account data and any other data that can identify certain individual 
 * or entity.
 */
public interface DataModificationAuditMessage extends TransactionalAuditLogMessage {
	
	/**
	 * Sets the audited object where the modified personal data are contained.
	 * 
	 * @param object  The object where the modified personal data that is being audit logged is contained.
	 */
	void setObject(AuditedObject object);
	
	/**
	 * Sets the audited data subject which is the owner of the modified personal data audit logged with this event.
	 * 
	 * @param dataSubject  The data subject whom the modified personal data that is being audit logged belongs to.
	 */
	void setDataSubject(AuditedDataSubject dataSubject);
	
	/**
	 * Used when a new value is added, and existing one is modified or removed. Sets the heading name for the attribute that has been modified.
	 * 
	 * @param name The attribute name.
	 * @param oldValue The old value of the attribute. Must be <code>null</code> for a new data set key.
	 * @param newValue The new value of the attribute. Must be <code>null</code> for a deleted data set key.
	 */
	void addAttribute(String name, String oldValue, String newValue);

}
