package com.sap.cds.repackaged.audit.api.v2;

import com.sap.cds.repackaged.audit.api.AuditLogMessage;

/**
 * An interface that allows logging of all security relevant events.
 * 
 * Security relevant events comprise all those events which may impact the confidentiality, the integrity, and/or the availability (CIA) of the system.
 * 
 * Examples of such events include: server start/stop, failed logins, failed authorization checks, start of critical transactions, changes of critical system parameters.
 * 
 */

public interface SecurityEventAuditMessage extends AuditLogMessage {

	/**
	 * Sets the source IP address (in case of external access) that triggered the event.
	 * 
	 * @param ip The source IP address.
	 */
	void setIp(String ip);

	/**
	 * Sets any data needed to fully understand the security relevant event.
	 * 
	 * @param data The detailed data describing this security event.
	 */
	void setData(String data);

	/**
	 * Add security attribute to the list
	 * 
	 * @param name The security attribute name
	 * @param value The security attribute value
	 */
	void addAttribute(String name, String value);

}
