package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.CredentialType;

public class ClientIdentityFactoryImpl implements ClientIdentityFactory {

    private static final String XSUAA_CREDENTIALS_CANNOT_BE_NULL = "XSUAA Credentials cannot be null";

    @Override
    public ClientIdentity createClientIdentity(OAuthCredentials oauthCredentials) {
        if(oauthCredentials == null) {
            throw new IllegalStateException(XSUAA_CREDENTIALS_CANNOT_BE_NULL);
        }
        if(CredentialType.X509.toString().equals(oauthCredentials.getCredentialType())) {
            return new ClientCertificate(oauthCredentials.getCertificate(), oauthCredentials.getKey(), oauthCredentials.getClientid());
        }
        return new ClientCredentials(oauthCredentials.getClientid(), oauthCredentials.getClientsecret());
    }

}
