package com.sap.cds.repackaged.audit.client.impl;

public class ConnectionConfigLoaderConstants {
    static final String XS_AUDIT_LOG_CLIENT_CONFIG_ENV = "XS_AUDIT_LOG_CLIENT_CONFIG";
    
    static final String MAX_RETRY_COUNT_ON_HTTP_ERROR_RESPONSE = "max_retry_count_on_http_error_response";
    static final String MAX_RETRY_COUNT_ON_EXCEPTION = "max_retry_count_on_exception";
    static final String DELAY_RETRY_ON_HTTP_ERROR_RESPONSE = "delay_retry_on_http_error_response";
    static final String DELAY_RETRY_ON_EXCEPTION = "delay_retry_on_exception";
    static final String CONNECTION_KEEP_ALIVE_TIME = "connection_keep_alive_time";
    static final String CONNECTION_REQUEST_TIMEOUT = "connection_request_timeout";
    static final String CONNECT_TIMEOUT = "connect_timeout";
    static final String SOCKET_TIMEOUT = "socket_timeout";
    static final String HTTP_POOL_MAX_CONN = "http_pool_max_conn";
    static final String HTTP_POOL_MAX_CONN_PER_ROUTE = "http_pool_max_conn_per_route";
    
    // Number of connection attempts in case of a HTTP response with error code
    // (only handles 503 Service Unavailable and 404 Not Found).
    // Default value is 3, which means that there will be up to 3 attempts to send
    // the message besides the initial attempt.
    static final Integer MAX_RETRY_COUNT_ON_HTTP_ERROR_RESPONSE_VALUE = 3;
    // Delay time (in milliseconds) before sending again an audit message in case an
    // error response code has been returned.
    // Only used if 'max_retry_count_on_http_error_response' property is set to a
    // positive number. Default value is 200.
    static final Integer DELAY_RETRY_ON_HTTP_ERROR_RESPONSE_VALUE = 200;
    // Number of connection retries in case of low level connection errors (e.g.
    // connect or read timeout).
    // Default value is 3.
    static final Integer MAX_RETRY_COUNT_ON_EXCEPTION_VALUE = 3;
    // Delay time (in milliseconds) before sending again an audit message in case of
    // low level connectivity problem.
    // Only used if 'max_retry_count_on_exception' property is set to a positive
    // number. Default value is 200.
    static final Integer DELAY_RETRY_ON_EXCEPTION_VALUE = 200;
    // The duration, in milliseconds, which any connection can be kept idle. Default
    // value is 30000.
    static final Integer CONNECTION_KEEP_ALIVE_TIME_VALUE = 30 * 1000;
    // The timeout, in milliseconds, used when requesting a connection from the
    // connection manager.
    // Default value is 10000 (overrides the default of -1, undefined (system
    // default)).
    static final Integer CONNECTION_REQUEST_TIMEOUT_VALUE = 10000;
    // The timeout, in milliseconds, until a connection is established.
    // Default value is 5000 (overrides the default of -1, undefined (system
    // default)).
    static final Integer CONNECT_TIMEOUT_VALUE = 5000;
    // The timeout, in milliseconds, waiting for data, i.e. the maximum period of
    // inactivity between two consecutive data packets.
    // Default value is 7000 (overrides the default of -1, undefined (system
    // default)).
    static final Integer SOCKET_TIMEOUT_VALUE = 7000;
    // The maximum count of http connections. Default value is 200 (overrides the
    // default of 20).
    static final Integer HTTP_POOL_MAX_CONN_VALUE = 200;
    // The maximum count of http connections per route. Default value is 200
    // (overrides the default of 2).
    static final Integer HTTP_POOL_MAX_CONN_PER_ROUTE_VALUE = 200;
}
