package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cds.repackaged.audit.api.exception.AuditLogNotAvailableException;
import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;
import com.sap.cds.repackaged.audit.client.impl.config.ConfigLoader;
import com.sap.cds.repackaged.audit.client.impl.config.ConfigLoaderImpl;

public class ConsoleCommunicator implements Communicator {
    private static final String AUDIT_LOG_ENABLE_OUTPUT_TO_CONSOLE_ENV = "AUDIT_LOG_ENABLE_OUTPUT_TO_CONSOLE";
    private static final String SEND_MESSAGE = "{\"id\":\"none\"}";
    private ConfigLoader configLoader;

    ConsoleCommunicator(ConfigLoader configLoader) {
        this.configLoader = configLoader;
    }

    public ConsoleCommunicator() {
        this(new ConfigLoaderImpl());
    }

    @Override
    public String send(String message, String endpoint, String subscriberTenantIssuer) throws AuditLogNotAvailableException {
        System.out.println(endpoint + ": " + message);
        try {
            configLoader.getRequiredEnvironmentVariable(AUDIT_LOG_ENABLE_OUTPUT_TO_CONSOLE_ENV);
        } catch (RuntimeException e) {
            throw new AuditLogNotAvailableException("Cannot send audit log message to the backend."
                    + " Missing audit log service credentials parameters or binding to an auditlog service instance.");
        }
        return SEND_MESSAGE;
    }

    @Override
    public String getServiceUrl() {
        return "audit/";
    }

    @Override
    public String getServicePlan() {
        return "standard";
    }

    @Override
    public String getUaaDomain() {
        return null;
    }

    @Override
    public String getClientId() {
        return "";
    }

    @Override
    public boolean isX509CredentialType() throws AuditLogWriteException {
        return false;
    }
}
