package com.sap.cds.repackaged.audit.client.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OAuthCredentials {

    @JsonProperty("clientid")
    private String clientid;

    @JsonProperty("clientsecret")
    private String clientsecret;

    @JsonProperty("url")
    private String url;

    @JsonProperty("certificate")
    private String certificate;

    @JsonProperty("key")
    private String key;

    @JsonProperty("certurl")
    private String certurl;

    @JsonProperty("uaadomain")
    private String uaaDomain;

    @JsonProperty("xsappname")
    private String xsappName;

    @JsonProperty("verificationkey")
    private String verificationKey;

    @JsonProperty("credential-type")
    private String credentialType;
    
    private String subscriberTokenIssuer;


    public OAuthCredentials() {
        // do nothing
    }

    public String getClientid() {
        return clientid;
    }

    public String getClientsecret() {
        return clientsecret;
    }

    public String getUrl() {
        return url;
    }

    public String getCertificate() {
        return certificate;
    }

    public String getKey() {
        return key;
    }

    public String getCerturl() {
        return certurl;
    }

    public String getUaaDomain() {
        return uaaDomain;
    }

    public String getXsappName() {
        return xsappName;
    }

    public String getVerificationKey() {
        return verificationKey;
    }

    public String getCredentialType() {
        return credentialType;
    }
    
    public String getSubscriberTokenIssuer() {
        return subscriberTokenIssuer;
    }

    public void setSubscriberTokenIssuer(String subscriberTokenIssuer) {
        this.subscriberTokenIssuer = subscriberTokenIssuer;
    }

}
