package com.sap.cds.repackaged.audit.client.impl;

import static com.sap.cds.repackaged.audit.client.impl.Utils.CLIENT_TYPE_TOKEN;
import static com.sap.cds.repackaged.audit.client.impl.Utils.USER_TYPE_TOKEN;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.GrantType;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.TokenClaims;

public class SecurityContextToken {
	private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContextToken.class);
	private final Token token;

	public SecurityContextToken(Token token) {
		this.token = token;
	}
	
	public String getClientId() {
	    return token.getClientId();
	}

	public String getLogonName() {
		return token.getPrincipal().getName();
	}

    public String getGrantType() {
        if (Service.XSUAA != token.getService()) {
            LOGGER.warn("There is no GRANT_TYPE claim for token of type {}", token.getService());
            return null;
        }

        final GrantType grantType = ((AccessToken)token).getGrantType();
        if (grantType == null) {
            LOGGER.warn("The enum of token's grant type [%s] cannot be found!", token.getClaimAsString(TokenClaims.XSUAA.GRANT_TYPE));
            return null;
        }

        return (grantType == GrantType.CLIENT_CREDENTIALS) ? CLIENT_TYPE_TOKEN : USER_TYPE_TOKEN;
    }

	public String getToken() {
		return token.getTokenValue();
	}

	public String getSubdomain() {
		return token.getAttributeFromClaimAsString(TokenClaims.XSUAA.EXTERNAL_ATTRIBUTE, TokenClaims.XSUAA.EXTERNAL_ATTRIBUTE_ZDN);
	}

}
