package com.sap.cds.repackaged.audit.client.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;

public class TokenFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenFactory.class);

    private final XsuaaTokenFlows xsuaaTokenFlows;

    public TokenFactory(XsuaaTokenFlows xsuaaTokenFlows) {
        this.xsuaaTokenFlows = xsuaaTokenFlows;
    }

    public String getClientCredentialsGrantAccessToken()
            throws IllegalArgumentException, TokenFlowException {
        final OAuth2TokenResponse response = xsuaaTokenFlows.clientCredentialsTokenFlow()
                .disableCache(false)
                .execute();
        LOGGER.info("Got client credentials grant JWT token");
        return response.getAccessToken();
    }

}
