package com.sap.cds.repackaged.audit.client.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.security.adapter.spring.SpringSecurityContext;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;

public class Utils {

	private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

	public static final String CLIENT_TYPE_TOKEN = "client";
	public static final String USER_TYPE_TOKEN = "user";
	public static final String OAUTH2_PLAN = "oauth2";
	public static final String STANDARD_PLAN = "standard";
	public static final String AUDIT_SERVICE_URL_PREFIX = "/audit-log/";
	public static final String LOGGER_NAME = "/System/AuditLog";
	public static final String PROVIDER_VALUE = "$PROVIDER";
	public static final String SUBSCRIBER_VALUE = "$SUBSCRIBER";
	public static final String USER_VALUE = "$USER";
	public static final String IDP_VALUE = "$IDP";
	public static final String SEND_MESSAGE_ERROR = "Cannot send audit log message to the backend: audit log service environment configuration is missing or incomplete.";
    public static final String INVALID_SUBSCRIBER_TOKEN_ISSUER_ERROR= "Invalid subscriber token issuer was passed, could not validate.";	
	public static final String APPLICATION_JSON = "application/json; charset=utf-8";

	public static String getUser() {
		final SecurityContextToken token = getSecurityContextToken();
		if (token != null) {
			return getUserFromToken(token);
		}
		return null;
	}

	private static String getUserFromToken(final SecurityContextToken token) {
		String user = null;
		if (CLIENT_TYPE_TOKEN.equals(token.getGrantType())) {
			user = token.getClientId();
		}
		return (user != null) ? user : token.getLogonName();
	}

	public static SecurityContextToken getSecurityContextToken() {
		Token token = SecurityContext.getToken();
		if (token == null) {
			LOGGER.debug("There is no token in the SecurityContext. Will try to get one from Spring SecurityContext.");
			try {
			    Class.forName("org.springframework.security.core.context.SecurityContextHolder");
			    token = SpringSecurityContext.getToken();
			} catch (final ClassNotFoundException e) {
			    LOGGER.debug("SecurityContextHolder class is not set in the classpath");
			}
		}
		return token != null ? new SecurityContextToken(token) : null;
	}
}
