package com.sap.cds.repackaged.audit.client.impl.v2;

import java.util.UUID;

import com.sap.cds.repackaged.audit.api.v2.DataAccessAuditMessage;
import com.sap.cds.repackaged.audit.client.impl.AuditLogMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.xs.audit.message.DataAccess;
import com.sap.cds.repackaged.audit.api.v2.AuditedDataSubject;
import com.sap.cds.repackaged.audit.api.v2.AuditedObject;

/**
 * This class implements the main audit log message interfaces, and encapsulates the formating functionality of the audit log messages. This object is not thread safe thus in case
 * of parallel threads its access need to be synchronized.
 * 
 */
public class DataAccessMessageImpl extends AuditLogMessageImpl<DataAccess> implements DataAccessAuditMessage {

	DataAccessMessageImpl(Communicator communicator) {
		super(communicator);
		this.endpoint = communicator.getServiceUrl() + "data-accesses";
		message = new DataAccess();
		message.setUuid(UUID.randomUUID().toString());
	}

	public void setChannel(String channel) {
		ensureNotLogged();
		message.setChannel(channel);
	}

	@Override
	public void addAttribute(String name, boolean isSuccessful) {
		ensureNotLogged();
		message.addAttribute(name, isSuccessful);
	}

	@Override
	public void addAttribute(String name) {
		ensureNotLogged();
		message.addAttribute(name);
	}

	public void addAttachment(String id, String name) {
		ensureNotLogged();
		message.addAttachment(id, name);
	}

	@Override
	public void setObject(AuditedObject ao) {
		ensureNotLogged();
		message.setObject(((AuditedObjectImpl) ao).getAuditedObjectPOJO());
	}

	@Override
	public void setDataSubject(AuditedDataSubject ads) {
		ensureNotLogged();
		message.setDataSubject(((AuditedDataSubjectImpl) ads).getAuditedDataSubjectPOJO());
	}

	@Override
	public void addDataSubject(AuditedDataSubject dataSubject) {
		ensureNotLogged();
		message.addDataSubject(((AuditedDataSubjectImpl) dataSubject).getAuditedDataSubjectPOJO());

	}
}
