package com.sap.cds.repackaged.audit.client.impl.v2;

import java.util.UUID;

import com.sap.cds.repackaged.audit.api.v2.DataModificationAuditMessage;
import com.sap.cds.repackaged.audit.api.exception.AuditLogNotAvailableException;
import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.cds.repackaged.audit.client.impl.TransactionalLogImpl;
import com.sap.xs.audit.message.DataModification;
import com.sap.cds.repackaged.audit.api.v2.AuditedDataSubject;
import com.sap.cds.repackaged.audit.api.v2.AuditedObject;

/**
 * This class implements the main audit log message interfaces, and encapsulates the formating functionality of the audit log messages. This object is not thread safe thus in case
 * of parallel threads its access need to be synchronized.
 * 
 */
public class DataModificationMessageImpl extends TransactionalLogImpl<DataModification> implements DataModificationAuditMessage {

	DataModificationMessageImpl(Communicator communicator) {
		super(communicator);
		this.endpoint = communicator.getServiceUrl() + "data-modifications";
		message = new DataModification();
		message.setUuid(UUID.randomUUID().toString());
	}

	@Override
	public void addAttribute(String name, String oldValue, String newValue) {
		ensureNotLogged();
		message.addAttribute(name, oldValue, newValue, null);
	}

	@Override
	public void log() throws AuditLogNotAvailableException, AuditLogWriteException {
		logSuccess();
	}

	@Override
	public void setObject(AuditedObject ao) {
		ensureNotLogged();
		message.setObject(((AuditedObjectImpl) ao).getAuditedObjectPOJO());
	}

	@Override
	public void setDataSubject(AuditedDataSubject ads) {
		ensureNotLogged();
		message.setDataSubject(((AuditedDataSubjectImpl) ads).getAuditedDataSubjectPOJO());
	}
}
