package com.sap.cds.repackaged.audit.client.impl.v2;

import java.util.UUID;

import com.sap.cds.repackaged.audit.api.v2.SecurityEventAuditMessage;
import com.sap.cds.repackaged.audit.client.impl.AuditLogMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.xs.audit.message.SecurityEvent;

/**
 * This class implements the main audit log message interfaces, and encapsulates the formating functionality of the audit log messages. This object is not thread safe thus in case
 * of parallel threads its access need to be synchronized.
 * 
 */
public class SecurityEventMessageImpl extends AuditLogMessageImpl<SecurityEvent> implements SecurityEventAuditMessage {

	SecurityEventMessageImpl(Communicator communicator) {
		super(communicator);
		this.endpoint = communicator.getServiceUrl() + "security-events";
		message = new SecurityEvent();
		message.setUuid(UUID.randomUUID().toString());
	}

	public void setIp(String ip) {
		ensureNotLogged();
		message.setIp(ip);
	}

	public void setData(String data) {
		ensureNotLogged();
		message.setData(data);
	}

	public void addAttribute(String name, String value) {
		ensureNotLogged();
		message.addAttribute(name, value);
	}
}
