/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.auditlog.v2;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.net.URI;
import java.util.Map;

class AuditLogV2Utils {
    static final String PREMIUM_PLAN = "premium";

    AuditLogV2Utils() {
    }

    static String getServiceUrl(Map<String, Object> credentials, boolean oAuth2) {
        String url = (String)credentials.get("url");
        URI uri = URI.create(url).normalize();
        String auditServicePath = "/audit-log/" + (oAuth2 ? "oauth2/" : "") + "v2/";
        if (!uri.getPath().endsWith(auditServicePath)) {
            uri = uri.resolve(auditServicePath);
        }
        return uri.toASCIIString();
    }

    static boolean isOAuth2BasedServicePlan(ServiceBinding binding) {
        String servicePlan = binding.getServicePlan().orElse(null);
        return "oauth2".equals(servicePlan) || PREMIUM_PLAN.equals(servicePlan);
    }

    static boolean isStandardPlan(ServiceBinding binding) {
        String servicePlan = binding.getServicePlan().orElse(null);
        return "standard".equals(servicePlan);
    }

    static void validateBinding(ServiceBinding binding) {
        Map uaa;
        Map cred = binding.getCredentials();
        if (cred == null || cred.isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.AUDITLOG_SERVICE_INVALID_CONFIG, new Object[]{"credentials"});
        }
        if (!cred.containsKey("url") || StringUtils.isEmpty((String)((String)cred.get("url")))) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.AUDITLOG_SERVICE_INVALID_CONFIG, new Object[]{"credentials.url"});
        }
        if (AuditLogV2Utils.isOAuth2BasedServicePlan(binding) && ((uaa = (Map)cred.get("uaa")) == null || uaa.isEmpty())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.AUDITLOG_SERVICE_INVALID_CONFIG, new Object[]{"credentials.uaa"});
        }
    }
}

