/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.sap.cds.repackaged.audit.client.impl.ConnectionConfigLoaderConstants;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionConfigLoader.class);
    private Map<String, Integer> connectionPropertiesMap = this.createMapWithDefaultValues();

    public ConnectionConfigLoader(String env) {
        this.readConfigurationsFromEnv(env);
    }

    private Map<String, Integer> createMapWithDefaultValues() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("max_retry_count_on_http_error_response", ConnectionConfigLoaderConstants.MAX_RETRY_COUNT_ON_HTTP_ERROR_RESPONSE_VALUE);
        map.put("max_retry_count_on_exception", ConnectionConfigLoaderConstants.MAX_RETRY_COUNT_ON_EXCEPTION_VALUE);
        map.put("delay_retry_on_http_error_response", ConnectionConfigLoaderConstants.DELAY_RETRY_ON_HTTP_ERROR_RESPONSE_VALUE);
        map.put("delay_retry_on_exception", ConnectionConfigLoaderConstants.DELAY_RETRY_ON_EXCEPTION_VALUE);
        map.put("connection_keep_alive_time", ConnectionConfigLoaderConstants.CONNECTION_KEEP_ALIVE_TIME_VALUE);
        map.put("connection_request_timeout", ConnectionConfigLoaderConstants.CONNECTION_REQUEST_TIMEOUT_VALUE);
        map.put("connect_timeout", ConnectionConfigLoaderConstants.CONNECT_TIMEOUT_VALUE);
        map.put("socket_timeout", ConnectionConfigLoaderConstants.SOCKET_TIMEOUT_VALUE);
        map.put("http_pool_max_conn", ConnectionConfigLoaderConstants.HTTP_POOL_MAX_CONN_VALUE);
        map.put("http_pool_max_conn_per_route", ConnectionConfigLoaderConstants.HTTP_POOL_MAX_CONN_PER_ROUTE_VALUE);
        return map;
    }

    private void readConfigurationsFromEnv(String env) {
        String auditClientConfig;
        String string = auditClientConfig = env == null ? System.getenv("XS_AUDIT_LOG_CLIENT_CONFIG") : env;
        if (auditClientConfig != null && !auditClientConfig.isEmpty()) {
            JsonFactory jsonFactory = new JsonFactory();
            try (JsonParser parser = jsonFactory.createParser(auditClientConfig);){
                while (parser.nextToken() != null) {
                    String connectionProperty;
                    if (!this.isTokenScalarValue(parser) || !this.connectionPropertiesMap.containsKey(connectionProperty = String.valueOf(parser.getCurrentName()))) continue;
                    this.connectionPropertiesMap.put(connectionProperty, parser.getValueAsInt());
                }
            }
            catch (IOException e) {
                LOGGER.error("XS_AUDIT_LOG_CLIENT_CONFIG environment var could not be parsed!", (Throwable)e);
            }
        }
    }

    private boolean isTokenScalarValue(JsonParser parser) {
        return parser.getCurrentToken().isScalarValue();
    }

    public int getMaxRetryCountOnHttpErrorResponse() {
        return this.connectionPropertiesMap.get("max_retry_count_on_http_error_response");
    }

    public int getMaxRetryCountOnException() {
        return this.connectionPropertiesMap.get("max_retry_count_on_exception");
    }

    public int getDelayRetryOnHttpErrorResponse() {
        return this.connectionPropertiesMap.get("delay_retry_on_http_error_response");
    }

    public int getDelayRetryOnException() {
        return this.connectionPropertiesMap.get("delay_retry_on_exception");
    }

    public int getConnectionKeepAliveTime() {
        return this.connectionPropertiesMap.get("connection_keep_alive_time");
    }

    public int getConnectionRequestTimeout() {
        return this.connectionPropertiesMap.get("connection_request_timeout");
    }

    public int getConnectTimeout() {
        return this.connectionPropertiesMap.get("connect_timeout");
    }

    public int getSocketTimeout() {
        return this.connectionPropertiesMap.get("socket_timeout");
    }

    public int getHttpPoolMaxConn() {
        return this.connectionPropertiesMap.get("http_pool_max_conn");
    }

    public int getHttpPoolMaxConnPerRoute() {
        return this.connectionPropertiesMap.get("http_pool_max_conn_per_route");
    }
}

