/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cds.repackaged.audit.api.exception.InvalidTokenIssuerException;
import com.sap.cds.repackaged.audit.client.impl.OAuthCredentials;
import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.OAuth2ServiceConfigurationBuilder;
import com.sap.cloud.security.config.Service;
import com.sap.xs.audit.message.ValidationError;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2ServiceConfigurationFactory {
    private static final String SUBSCRIBER_TOKEN_ISSUER_IS_INVALID = "Subscriber token issuer is invalid!";
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2ServiceConfigurationFactory.class);

    public OAuth2ServiceConfiguration getOAuth2ServiceConfiguration(OAuthCredentials oauthCredentials) throws InvalidTokenIssuerException {
        OAuth2ServiceConfiguration config = oauthCredentials.getCerturl() == null ? this.getOAuth2Config(oauthCredentials) : this.getOAuth2ConfigX509(oauthCredentials);
        return config;
    }

    private OAuth2ServiceConfiguration getOAuth2ConfigX509(OAuthCredentials oauthCredentials) throws InvalidTokenIssuerException {
        String certUrl = this.decideOnUrl(oauthCredentials.getCerturl(), oauthCredentials.getSubscriberTokenIssuer());
        return OAuth2ServiceConfigurationBuilder.forService((Service)Service.XSUAA).withClientId(oauthCredentials.getClientid()).withCertUrl(certUrl).withCertificate(oauthCredentials.getCertificate()).withPrivateKey(oauthCredentials.getKey()).withCredentialType(CredentialType.X509).build();
    }

    private OAuth2ServiceConfiguration getOAuth2Config(OAuthCredentials oauthCredentials) throws InvalidTokenIssuerException {
        String url = this.decideOnUrl(oauthCredentials.getUrl(), oauthCredentials.getSubscriberTokenIssuer());
        return OAuth2ServiceConfigurationBuilder.forService((Service)Service.XSUAA).withClientId(oauthCredentials.getClientid()).withClientSecret(oauthCredentials.getClientsecret()).withUrl(url).build();
    }

    private String decideOnUrl(String providerTokenIssuer, String subscriberTokenIssuer) throws InvalidTokenIssuerException {
        if (subscriberTokenIssuer != null) {
            LOGGER.debug("Subscriber token issuer is present: {}", (Object)subscriberTokenIssuer);
            try {
                this.validateSubscriberTokenIssuer(providerTokenIssuer, subscriberTokenIssuer);
                return subscriberTokenIssuer;
            }
            catch (ValidationError e) {
                throw new InvalidTokenIssuerException("Invalid subscriber token issuer was passed, could not validate.", e);
            }
        }
        return providerTokenIssuer;
    }

    private void validateSubscriberTokenIssuer(String providerTokenIssuer, String subscriberTokenIssuer) throws ValidationError {
        String providerTokenIssuerDomain;
        String subscriberTokenIssuerDomain = this.extractDomain(subscriberTokenIssuer);
        if (!subscriberTokenIssuerDomain.equals(providerTokenIssuerDomain = this.extractDomain(providerTokenIssuer))) {
            throw new ValidationError(SUBSCRIBER_TOKEN_ISSUER_IS_INVALID);
        }
    }

    private String extractDomain(String tokenIssuer) throws ValidationError {
        try {
            String host = new URI(tokenIssuer).getHost();
            return host.substring(host.indexOf("."));
        }
        catch (URISyntaxException e) {
            throw new ValidationError(SUBSCRIBER_TOKEN_ISSUER_IS_INVALID);
        }
    }
}

