/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cds.repackaged.audit.api.exception.InvalidTokenIssuerException;
import com.sap.cds.repackaged.audit.client.impl.ClientIdentityFactory;
import com.sap.cds.repackaged.audit.client.impl.ClientIdentityFactoryImpl;
import com.sap.cds.repackaged.audit.client.impl.OAuth2ServiceConfigurationFactory;
import com.sap.cds.repackaged.audit.client.impl.OAuthCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;

public class XsuaaTokenFlowsFactory {
    private static final int MAX_MAP_CAPACITY = 1000;
    private final HttpClient httpClient;
    private final ClientIdentityFactory clientIdentityFactory;
    private final OAuth2ServiceConfigurationFactory configFactory;
    private final Map<String, XsuaaTokenFlows> xsuaaTokenFlowsMap;

    XsuaaTokenFlowsFactory(HttpClient httpClient, ClientIdentityFactory clientIdentityFactory, OAuth2ServiceConfigurationFactory configFactory, Map<String, XsuaaTokenFlows> tokenFlowsMap) {
        this.httpClient = httpClient;
        this.clientIdentityFactory = clientIdentityFactory;
        this.configFactory = configFactory;
        this.xsuaaTokenFlowsMap = tokenFlowsMap;
    }

    public XsuaaTokenFlowsFactory(HttpClient httpClient) {
        this(httpClient, new ClientIdentityFactoryImpl(), new OAuth2ServiceConfigurationFactory(), XsuaaTokenFlowsFactory.createLinedHashMap());
    }

    public XsuaaTokenFlows getXsuaaTokenFlows(OAuthCredentials oauthCredentials) throws InvalidTokenIssuerException {
        String subscriberIssuer = oauthCredentials.getSubscriberTokenIssuer();
        if (subscriberIssuer == null) {
            String providerIssuer = this.getProviderIssuer(oauthCredentials);
            return this.getXsuaaTokenFlows(oauthCredentials, providerIssuer);
        }
        return this.getXsuaaTokenFlows(oauthCredentials, subscriberIssuer);
    }

    private XsuaaTokenFlows getXsuaaTokenFlows(OAuthCredentials oauthCredentials, String tokenIssuer) throws InvalidTokenIssuerException {
        XsuaaTokenFlows tokenIssuerTokenFlows = this.xsuaaTokenFlowsMap.get(tokenIssuer);
        if (tokenIssuerTokenFlows == null) {
            XsuaaTokenFlows tokenFlows = this.createXsuaaTokenFlows(oauthCredentials);
            this.xsuaaTokenFlowsMap.put(tokenIssuer, tokenFlows);
            return tokenFlows;
        }
        return tokenIssuerTokenFlows;
    }

    private String getProviderIssuer(OAuthCredentials oauthCredentials) {
        String providerIssuer = oauthCredentials.getCerturl();
        return providerIssuer != null ? providerIssuer : oauthCredentials.getUrl();
    }

    private XsuaaTokenFlows createXsuaaTokenFlows(OAuthCredentials oauthCredentials) throws InvalidTokenIssuerException {
        ClientIdentity clientIdentity = this.clientIdentityFactory.createClientIdentity(oauthCredentials);
        OAuth2ServiceConfiguration config = this.configFactory.getOAuth2ServiceConfiguration(oauthCredentials);
        XsuaaTokenFlows tokenFlows = new XsuaaTokenFlows((OAuth2TokenService)new DefaultOAuth2TokenService((CloseableHttpClient)this.httpClient), (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(config), clientIdentity);
        return tokenFlows;
    }

    private static Map<String, XsuaaTokenFlows> createLinedHashMap() {
        return new LinkedHashMap<String, XsuaaTokenFlows>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, XsuaaTokenFlows> eldest) {
                return this.size() > 1000;
            }
        };
    }
}

