/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl.v2;

import com.sap.cds.repackaged.audit.api.exception.AuditLogNotAvailableException;
import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;
import com.sap.cds.repackaged.audit.api.v2.AuditedObject;
import com.sap.cds.repackaged.audit.api.v2.ConfigurationChangeAuditMessage;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.cds.repackaged.audit.client.impl.TransactionalLogImpl;
import com.sap.cds.repackaged.audit.client.impl.v2.AuditedObjectImpl;
import com.sap.xs.audit.message.ConfigurationChange;
import java.util.UUID;

public class ConfigurationChangeMessageImpl
extends TransactionalLogImpl<ConfigurationChange>
implements ConfigurationChangeAuditMessage {
    protected Object messageId;

    ConfigurationChangeMessageImpl(Communicator communicator) {
        super(communicator);
        this.endpoint = communicator.getServiceUrl() + "configuration-changes";
        this.message = new ConfigurationChange();
        ((ConfigurationChange)this.message).setUuid(UUID.randomUUID().toString());
    }

    @Override
    public void addValue(String name, String oldValue, String newValue) {
        this.ensureNotLogged();
        ((ConfigurationChange)this.message).addAttribute(name, oldValue, newValue);
    }

    @Override
    public void log() throws AuditLogNotAvailableException, AuditLogWriteException {
        this.logSuccess();
    }

    @Override
    public void setObject(AuditedObject ao) {
        this.ensureNotLogged();
        ((ConfigurationChange)this.message).setObject(((AuditedObjectImpl)ao).getAuditedObjectPOJO());
    }
}

