/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message;

import com.sap.xs.audit.message.AuditLogMessageBase;
import com.sap.xs.audit.message.ConfigurationChange;
import com.sap.xs.audit.message.DataAccess;
import com.sap.xs.audit.message.DataModification;
import com.sap.xs.audit.message.SecurityEvent;
import com.sap.xs.audit.message.TransactionalStatusMessage;
import java.util.Objects;
import java.util.Optional;

public enum AuditLogMessageCategory {
    CONFIGURATION_CHANGE(ConfigurationChange.class, "audit.configuration"),
    DATA_ACCESS(DataAccess.class, "audit.data-access"),
    DATA_MODIFICATION(DataModification.class, "audit.data-modification"),
    SECURITY_EVENT(SecurityEvent.class, "audit.security-events"),
    CONFIGURATION_CHANGE_TXN_STATUS(TransactionalStatusMessage.class, "audit.configuration.txn-status"),
    DATA_MODIFICATION_TXN_STATUS(TransactionalStatusMessage.class, "audit.data-modification.txn-status");

    private final Class<? extends AuditLogMessageBase> auditLogMessageClass;
    private final String categoryId;

    private AuditLogMessageCategory(Class<? extends AuditLogMessageBase> auditLogMessageClass, String categoryId) {
        this.auditLogMessageClass = Objects.requireNonNull(auditLogMessageClass);
        this.categoryId = Objects.requireNonNull(categoryId);
    }

    public Class<? extends AuditLogMessageBase> getAuditLogMessageClass() {
        return this.auditLogMessageClass;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public static Optional<AuditLogMessageCategory> fromCategoryId(String categoryId) {
        for (AuditLogMessageCategory auditLogMessageCategory : AuditLogMessageCategory.values()) {
            if (!auditLogMessageCategory.getCategoryId().equals(categoryId)) continue;
            return Optional.of(auditLogMessageCategory);
        }
        return Optional.empty();
    }
}

