/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPValidator {
    public static boolean isValidIP(String ip) {
        return IPValidator.isValidIP4Address(ip) || IPValidator.isValidIP6Address(ip);
    }

    public static boolean isValidIP4Address(String ip) {
        int ipV4_max_segment_value = 255;
        String[] ipSegments = IpV4Validator.match(ip);
        if (ipSegments == null) {
            return false;
        }
        for (String segment : ipSegments) {
            if (segment == null || segment.length() == 0) {
                return false;
            }
            int segmentInt = 0;
            try {
                segmentInt = Integer.parseInt(segment);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (segmentInt > ipV4_max_segment_value) {
                return false;
            }
            if (segment.length() <= 1 || !segment.startsWith("0")) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIP6Address(String ip) {
        int ipV6_max_segments = 8;
        int ipV6_max_segment_digits = 4;
        int radix = 16;
        int ipV6_max_segment_value = 65535;
        boolean hasOmittedZeroSections = ip.contains("::");
        if (hasOmittedZeroSections && ip.indexOf("::") != ip.lastIndexOf("::")) {
            return false;
        }
        if (ip.startsWith(":") && !ip.startsWith("::") || ip.endsWith(":") && !ip.endsWith("::")) {
            return false;
        }
        String[] segments = ip.split(":");
        if (hasOmittedZeroSections) {
            ArrayList<String> segmentsList = new ArrayList<String>(Arrays.asList(segments));
            if (ip.endsWith("::")) {
                segmentsList.add("");
            } else if (ip.startsWith("::") && !segmentsList.isEmpty()) {
                segmentsList.remove(0);
            }
            segments = segmentsList.toArray(new String[segmentsList.size()]);
        }
        if (segments.length > ipV6_max_segments) {
            return false;
        }
        int ipValidSegments = 0;
        int zeroSegments = 0;
        for (int index = 0; index < segments.length; ++index) {
            String segment = segments[index];
            if (segment.length() == 0) {
                if (++zeroSegments > 1) {
                    return false;
                }
            } else {
                zeroSegments = 0;
                if (index == segments.length - 1 && segment.contains(".")) {
                    if (!IPValidator.isValidIP4Address(segment)) {
                        return false;
                    }
                    ipValidSegments += 2;
                    continue;
                }
                if (segment.length() > ipV6_max_segment_digits) {
                    return false;
                }
                int segmentInt = 0;
                try {
                    segmentInt = Integer.parseInt(segment, radix);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (segmentInt < 0 || segmentInt > ipV6_max_segment_value) {
                    return false;
                }
            }
            ++ipValidSegments;
        }
        return ipValidSegments <= ipV6_max_segments && (ipValidSegments >= ipV6_max_segments || hasOmittedZeroSections);
    }

    private static class IpV4Validator {
        private static final String IP_V4_REGEX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
        private static Pattern pattern = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$", 2);

        private IpV4Validator() {
        }

        static String[] match(String value) {
            if (value == null) {
                return null;
            }
            Matcher matcher = pattern.matcher(value);
            if (matcher.matches()) {
                int count = matcher.groupCount();
                String[] groups = new String[count];
                for (int j = 0; j < count; ++j) {
                    groups[j] = matcher.group(j + 1);
                }
                return groups;
            }
            return null;
        }
    }
}

