/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking;

import com.sap.cds.feature.changetracking.ChangeTrackingService;
import com.sap.cds.feature.changetracking.Changes;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.ProjectionResolver;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class ChangeTrackerResultHandler {
    private static final String ASSOCIATION_TO_CHANGES = "changes";

    private ChangeTrackerResultHandler() {
    }

    static void handle(EventContext context, Map<Path, List<Changes>> result) {
        if (!result.isEmpty()) {
            ChangeTrackingService changeTrackingService = (ChangeTrackingService)context.getServiceCatalog().getService(ChangeTrackingService.class, "ChangeTrackingService$Default");
            changeTrackingService.createChanges(result.values().stream().flatMap(Collection::stream).toList());
            PersistenceService self = (PersistenceService)context.getService();
            result.forEach((k, v) -> {
                if (k.root().type().findAssociation(ASSOCIATION_TO_CHANGES).isPresent()) {
                    ChangeTrackerResultHandler.setLinks(self, k.root().segment(), v);
                } else {
                    ProjectionResolver resolver = ProjectionResolver.create((CdsModel)context.getModel(), (CqnStatement)Insert.into((StructuredType)CQL.to(List.of(k.root().segment()))));
                    CqnStructuredTypeRef domainRef = ((Insert)resolver.resolveAll().getResolvedStatement()).ref();
                    CdsEntity domainEntity = CdsModelUtils.entity((CdsModel)context.getModel(), (CqnStructuredTypeRef)domainRef);
                    if (domainEntity.findAssociation(ASSOCIATION_TO_CHANGES).isPresent()) {
                        ChangeTrackerResultHandler.setLinks(self, domainRef.rootSegment(), v);
                    }
                }
            });
        }
    }

    private static void setLinks(PersistenceService self, CqnReference.Segment root, List<Changes> v) {
        self.run((CqnInsert)Insert.into((StructuredType)CQL.to(List.of(root)).to(ASSOCIATION_TO_CHANGES)).entries(v.stream().map(c -> Map.of("change_ID", c.getId())).toList()));
    }
}

