/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking.components;

import com.google.common.collect.Maps;
import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.feature.changetracking.tracking.components.SelectionSetBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class EntityStateReader {
    private final Predicate<CdsElement> isChangeTracked;
    private final Predicate<CdsElement> isCascadedForInsert;
    private final Predicate<CdsElement> isCascadedForUpsert;
    private final Predicate<CdsElement> isCascadedForUpdate;
    private final Predicate<CdsElement> isCascadedForDelete;

    public EntityStateReader(Predicate<CdsElement> isChangeTracked) {
        this.isChangeTracked = isChangeTracked;
        this.isCascadedForInsert = e -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)e);
        this.isCascadedForUpsert = e -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)e) || CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)e);
        this.isCascadedForUpdate = e -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)e);
        this.isCascadedForDelete = e -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.DELETE, (CdsElement)e);
    }

    public List<Row> oldImage(CdsUpdateEventContext context) {
        return this.selectImageForUpdate(context).toList();
    }

    public List<Row> oldImage(CdsUpsertEventContext context) {
        return context.getCqn().entries().stream().flatMap(r -> EntityStateReader.readImage((EventContext)context, this.isChangeTracked, this.isCascadedForUpsert, r, Map.of())).toList();
    }

    public List<Row> oldImage(CdsDeleteEventContext context) {
        SelectionSetBuilder selectionSetBuilder = new SelectionSetBuilder((CdsStructuredType)context.getTarget(), this.isChangeTracked, this.isCascadedForDelete);
        List<CqnSelectListItem> trackedShape = selectionSetBuilder.get();
        if (!trackedShape.isEmpty()) {
            Select select = CqnUtils.toSelect((CqnDelete)context.getCqn()).columns(trackedShape);
            if (context.getCqnValueSets().iterator().hasNext()) {
                return StreamSupport.stream(context.getCqnValueSets().spliterator(), false).flatMap(arg_0 -> EntityStateReader.lambda$oldImage$5(context, (CqnSelect)select, arg_0)).toList();
            }
            return EntityStateReader.readInternal((EventContext)context, (CqnSelect)select, Map.of()).toList();
        }
        return Collections.emptyList();
    }

    public List<Row> newImage(CdsCreateEventContext context) {
        return context.getResult().stream().flatMap(r -> EntityStateReader.readImage((EventContext)context, this.isChangeTracked, this.isCascadedForInsert, (Map<String, Object>)r, Map.of())).toList();
    }

    public List<Row> newImage(CdsUpdateEventContext context) {
        return this.selectImageForUpdate(context).toList();
    }

    public List<Row> newImage(CdsUpsertEventContext context) {
        return context.getResult().stream().flatMap(r -> EntityStateReader.readImage((EventContext)context, this.isChangeTracked, this.isCascadedForUpsert, (Map<String, Object>)r, Map.of())).toList();
    }

    private Stream<Row> selectImageForUpdate(CdsUpdateEventContext context) {
        Iterator iterator = context.getCqnValueSets().iterator();
        List entries = context.getCqn().entries();
        Map setters = context.getCqn().setters();
        if (!iterator.hasNext()) {
            if (setters.isEmpty()) {
                return entries.stream().flatMap(e -> EntityStateReader.readImage((EventContext)context, this.isChangeTracked, this.isCascadedForUpdate, e, Map.of()));
            }
            return entries.stream().map(e -> this.mergeSetters(setters, (Map<String, Object>)e)).flatMap(e -> EntityStateReader.readImage((EventContext)context, this.isChangeTracked, this.isCascadedForUpdate, e, Map.of()));
        }
        Map<String, Object> template = setters.isEmpty() ? (Map<String, Object>)entries.get(0) : this.mergeSetters(setters, (Map)entries.get(0));
        return StreamSupport.stream(context.getCqnValueSets().spliterator(), false).flatMap(p -> EntityStateReader.readImage((EventContext)context, this.isChangeTracked, this.isCascadedForUpdate, template, p));
    }

    private Map<String, Object> mergeSetters(Map<String, CqnValue> setters, Map<String, Object> source) {
        HashMap<String, Object> result = new HashMap<String, Object>(source.size() + setters.size());
        result.putAll(source);
        setters.forEach((k, v) -> DataUtils.putPath((Map)result, (String)k, null));
        return result;
    }

    private static Stream<Row> readImage(EventContext context, Predicate<CdsElement> isChangeTracked, Predicate<CdsElement> isCascaded, Map<String, Object> row, Map<String, Object> params) {
        SelectionSetBuilder selectionSetBuilder = new SelectionSetBuilder((CdsStructuredType)context.getTarget(), isChangeTracked, isCascaded);
        List<CqnSelectListItem> trackedColumns = selectionSetBuilder.get(row);
        if (trackedColumns.isEmpty()) {
            return Stream.empty();
        }
        CqnSelect statement = EntityStateReader.buildStatement(context, row, trackedColumns);
        return EntityStateReader.readInternal(context, statement, params);
    }

    private static Stream<Row> readInternal(EventContext context, CqnSelect statement, Map<String, Object> params) {
        return ((Result)context.getCdsRuntime().requestContext().privilegedUser().modifyParameters(c -> c.setLocale(null)).run(rc -> ((CqnService)context.getService()).run(statement, params))).stream();
    }

    private static CqnSelect buildStatement(EventContext context, Map<String, Object> row, List<CqnSelectListItem> trackedColumns) {
        Map matchingKeys;
        CqnStatement cqn = (CqnStatement)context.get("cqn");
        Select statement = Select.from((CqnStructuredTypeRef)cqn.ref()).columns(trackedColumns);
        if (cqn instanceof CqnFilterableStatement) {
            CqnFilterableStatement filterableStatement = (CqnFilterableStatement)cqn;
            statement.where((CqnPredicate)filterableStatement.where().orElse(null));
        }
        if (!(matchingKeys = Maps.filterValues((Map)DataUtils.keyValues((CdsEntity)context.getTarget(), row), Objects::nonNull)).isEmpty()) {
            statement.where((CqnPredicate)CQL.matching((Map)matchingKeys).and((CqnPredicate)statement.where().orElse(CQL.TRUE), new CqnPredicate[0]));
        }
        return statement;
    }

    private static /* synthetic */ Stream lambda$oldImage$5(CdsDeleteEventContext context, CqnSelect select, Map p) {
        return EntityStateReader.readInternal((EventContext)context, select, p);
    }
}

