/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking;

import com.sap.cds.feature.changetracking.ChangeTrackingService;
import com.sap.cds.feature.changetracking.Changes;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CqnService;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class ChangeTrackerResultHandler {
    private ChangeTrackerResultHandler() {
    }

    static void handle(EventContext context, Map<Path, List<Changes>> result) {
        if (!result.isEmpty()) {
            ChangeTrackingService changeTrackingService = (ChangeTrackingService)context.getServiceCatalog().getService(ChangeTrackingService.class, "ChangeTrackingService$Default");
            changeTrackingService.createChanges(result.values().stream().flatMap(Collection::stream).toList());
            CqnService persistenceService = (CqnService)context.getServiceCatalog().getService(CqnService.class, "PersistenceService$Default");
            result.entrySet().stream().filter(e -> ((Path)e.getKey()).root().type().findAssociation("changes").isPresent()).forEach(e -> {
                List<Map> links = ((List)e.getValue()).stream().map(c -> Map.of("change_ID", c.getId())).toList();
                persistenceService.run((CqnInsert)Insert.into((StructuredType)CQL.entity((String)((Path)e.getKey()).root().type().getQualifiedName()).matching(((Path)e.getKey()).root().keyValues()).to("changes")).entries(links));
            });
        }
    }
}

