/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking.components;

import com.google.common.collect.Maps;
import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.feature.changetracking.tracking.components.ContextParameterHelper;
import com.sap.cds.feature.changetracking.tracking.components.SelectionSetBuilder;
import com.sap.cds.feature.changetracking.tracking.components.ShapeResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class EntityStateReader {
    private final Predicate<CdsElement> isChangeTracked;
    private final Predicate<CdsElement> isCascadedForInsert;
    private final Predicate<CdsElement> isCascadedForUpsert;
    private final Predicate<CdsElement> isCascadedForUpdate;
    private final Predicate<CdsElement> isCascadedForDelete;

    public EntityStateReader(Predicate<CdsElement> isChangeTracked) {
        this.isChangeTracked = isChangeTracked;
        this.isCascadedForInsert = e -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)e);
        this.isCascadedForUpsert = e -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)e) || CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)e);
        this.isCascadedForUpdate = e -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)e);
        this.isCascadedForDelete = e -> CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.DELETE, (CdsElement)e);
    }

    public List<Row> oldImage(CdsUpdateEventContext context) {
        List<Map<String, Object>> source = ShapeResolver.resolve(context.getTarget(), context.getCqn(), context.getCqnValueSets());
        ContextParameterHelper.checkInUpdateShape((EventContext)context, source);
        return this.selectImageForUpdate(context, source);
    }

    public List<Row> oldImage(CdsUpsertEventContext context) {
        return context.getCqn().entries().stream().flatMap(r -> EntityStateReader.readImage((EventContext)context, CqnUtils.toSelect((CqnUpsert)context.getCqn(), (CdsEntity)context.getTarget()), this.isChangeTracked, this.isCascadedForUpsert, r)).toList();
    }

    public List<Row> oldImage(CdsDeleteEventContext context) {
        SelectionSetBuilder selectionSetBuilder = new SelectionSetBuilder((CdsStructuredType)context.getTarget(), this.isChangeTracked, this.isCascadedForDelete);
        List<CqnSelectListItem> trackedShape = selectionSetBuilder.get();
        if (!trackedShape.isEmpty()) {
            Select select = CqnUtils.toSelect((CqnDelete)context.getCqn()).columns(trackedShape);
            if (context.getCqnValueSets().iterator().hasNext()) {
                return StreamSupport.stream(context.getCqnValueSets().spliterator(), false).flatMap(arg_0 -> EntityStateReader.lambda$oldImage$5(context, (CqnSelect)select, arg_0)).toList();
            }
            return context.getService().run((CqnSelect)select, new Object[0]).list();
        }
        return Collections.emptyList();
    }

    public List<Row> newImage(CdsCreateEventContext context) {
        Select statement = Select.from((CqnStructuredTypeRef)context.getCqn().ref());
        return context.getResult().stream().flatMap(r -> EntityStateReader.readImage((EventContext)context, statement, this.isChangeTracked, this.isCascadedForInsert, (Map<String, Object>)r)).toList();
    }

    public List<Row> newImage(CdsUpdateEventContext context) {
        Collection<Map<String, Object>> source = ContextParameterHelper.checkOutUpdateShape((EventContext)context);
        return this.selectImageForUpdate(context, source);
    }

    public List<Row> newImage(CdsUpsertEventContext context) {
        return context.getResult().stream().flatMap(r -> EntityStateReader.readImage((EventContext)context, CqnUtils.toSelect((CqnUpsert)context.getCqn(), (CdsEntity)context.getTarget()), this.isChangeTracked, this.isCascadedForUpsert, (Map<String, Object>)r)).toList();
    }

    private List<Row> selectImageForUpdate(CdsUpdateEventContext context, Collection<? extends Map<String, Object>> source) {
        Stream<? extends Map<String, Object>> entries = source.isEmpty() ? context.getCqn().entries().stream() : source.stream();
        return entries.flatMap(r -> EntityStateReader.readImage((EventContext)context, CqnUtils.toSelect((CqnUpdate)context.getCqn(), (CdsEntity)context.getTarget()), this.isChangeTracked, this.isCascadedForUpdate, (Map<String, Object>)DataUtils.copyMap((Map)r))).toList();
    }

    private static Stream<Row> readImage(EventContext context, Select<?> statement, Predicate<CdsElement> isChangeTracked, Predicate<CdsElement> isCascaded, Map<String, Object> row) {
        Set keys = CdsModelUtils.keyNames((CdsStructuredType)context.getTarget());
        SelectionSetBuilder selectionSetBuilder = new SelectionSetBuilder((CdsStructuredType)context.getTarget(), isChangeTracked, isCascaded);
        List<CqnSelectListItem> trackedColumns = selectionSetBuilder.get(row);
        if (trackedColumns.isEmpty()) {
            return Stream.empty();
        }
        Map matchingKeys = Maps.filterKeys(row, keys::contains);
        statement = matchingKeys.isEmpty() ? statement.columns(trackedColumns) : statement.columns(trackedColumns).matching(matchingKeys);
        statement.orderBy(keys.stream().map(k -> CQL.sort((CqnValue)CQL.get((String)k), (CqnSortSpecification.Order)CqnSortSpecification.Order.ASC)).toList());
        CqnSelect selectStatement = statement.asSelect();
        return ((Result)context.getCdsRuntime().requestContext().privilegedUser().modifyParameters(c -> c.setLocale(null)).run(rc -> ((CqnService)context.getService()).run(selectStatement, new Object[0]))).stream();
    }

    private static /* synthetic */ Stream lambda$oldImage$5(CdsDeleteEventContext context, CqnSelect select, Map p) {
        return context.getService().run(select, p).stream();
    }
}

