/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking.components;

import com.sap.cds.CdsList;
import com.sap.cds.feature.changetracking.tracking.components.IdentifierHelper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.services.draft.Drafts;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class SelectionSetBuilder {
    private final CdsStructuredType root;
    private final Predicate<CdsElement> isChangeTracked;
    private final Predicate<CdsElement> isCascaded;
    private final Set<String> visitedTypes = new HashSet<String>();

    public SelectionSetBuilder(CdsStructuredType root, Predicate<CdsElement> isChangeTracked, Predicate<CdsElement> isCascaded) {
        this.root = root;
        this.isChangeTracked = isChangeTracked;
        this.isCascaded = this.withoutAssociationToChangeLog(isCascaded);
        this.visitedTypes.add(root.getQualifiedName());
    }

    public List<CqnSelectListItem> get() {
        ChangeTrackedElementsFromType elementVisitor = new ChangeTrackedElementsFromType(this.isChangeTracked, this.isCascaded, Set.of(this.root.getQualifiedName()));
        this.root.accept((CdsVisitor)elementVisitor);
        return elementVisitor.getColumns();
    }

    public List<CqnSelectListItem> get(Map<String, Object> data) {
        return this.selectColumns(this.root, data);
    }

    private List<CqnSelectListItem> selectColumns(CdsStructuredType type, Map<String, Object> data) {
        LinkedList<CqnSelectListItem> columns = new LinkedList<CqnSelectListItem>();
        HashSet<CdsElement> assocElements = new HashSet<CdsElement>();
        for (String item : data.keySet()) {
            CdsElement element = type.getElement(item);
            if (element.getType().isAssociation() && (this.isCascaded.test(element) || this.isChangeTracked.test(element))) {
                assocElements.add(element);
                continue;
            }
            if (!this.isChangeTracked.test(element)) continue;
            String assoc = (String)CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrDefault((CdsAnnotatable)element);
            if (assoc != null) {
                assocElements.add(type.getElement(assoc));
                continue;
            }
            if (element.isKey()) continue;
            columns.add((CqnSelectListItem)CQL.get((String)element.getName()));
        }
        assocElements.stream().map(assocElement -> this.expandAssociation((CdsElement)assocElement, data)).forEach(columns::addAll);
        if (!columns.isEmpty()) {
            SelectionSetBuilder.addEntityIdentifier(type, columns);
        }
        return columns;
    }

    private List<CqnSelectListItem> expandAssociation(CdsElement element, Map<String, Object> data) {
        ArrayList<CqnSelectListItem> result = new ArrayList<CqnSelectListItem>();
        if (CdsModelUtils.isSingleValued((CdsType)element.getType())) {
            result.addAll(this.expandToOneAssociation(element, data));
        } else {
            result.addAll(this.expandToManyAssociation(element, data));
        }
        return result;
    }

    private List<CqnSelectListItem> expandToOneAssociation(CdsElement element, Map<String, Object> data) {
        List<ElementRef<Object>> identifierElements;
        CdsEntity target = ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget();
        if (this.visitedTypes.contains(target.getQualifiedName())) {
            return List.of();
        }
        this.visitedTypes.add(target.getQualifiedName());
        Map content = (Map)DataUtils.getOrDefault(data, (String)element.getName(), Map.of());
        LinkedList<CqnSelectListItem> selectList = new LinkedList<CqnSelectListItem>();
        if (this.isCascaded.test(element)) {
            if (content != null) {
                List<CqnSelectListItem> expandedColumns = this.selectColumns((CdsStructuredType)target, content);
                if (!expandedColumns.isEmpty()) {
                    selectList.addAll(expandedColumns);
                }
            } else {
                ChangeTrackedElementsFromType elementVisitor = new ChangeTrackedElementsFromType(this.isChangeTracked, this.isCascaded, this.visitedTypes);
                target.accept((CdsVisitor)elementVisitor);
                if (!elementVisitor.getColumns().isEmpty()) {
                    selectList.addAll(elementVisitor.getColumns());
                }
            }
        }
        if ((identifierElements = IdentifierHelper.elementsOfIdentifier((CdsAnnotatable)element)).isEmpty() && selectList.isEmpty() && this.isChangeTracked.test(element)) {
            return List.of(CQL.get((String)element.getName()));
        }
        CdsModelUtils.targetKeys((CdsElement)element).stream().map(CQL::get).forEach(selectList::add);
        SelectionSetBuilder.addElementIdentifier(element, selectList);
        return List.of(CQL.to((String)element.getName()).expand(selectList));
    }

    private List<CqnSelectListItem> expandToManyAssociation(CdsElement element, Map<String, Object> data) {
        List<ElementRef<Object>> identifier;
        CdsEntity target = ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget();
        if (this.visitedTypes.contains(target.getQualifiedName())) {
            return List.of();
        }
        this.visitedTypes.add(target.getQualifiedName());
        ArrayList<CqnSelectListItem> selectList = new ArrayList<CqnSelectListItem>();
        if (((CdsAssociationType)element.getType().as(CdsAssociationType.class)).isComposition() && !(identifier = IdentifierHelper.elementsOfIdentifier((CdsAnnotatable)element)).isEmpty()) {
            SelectionSetBuilder.addElementIdentifier(element, selectList);
        }
        ChangeTrackedElementsFromType elementVisitor = new ChangeTrackedElementsFromType(this.isChangeTracked, this.isCascaded, this.visitedTypes);
        target.accept((CdsVisitor)elementVisitor);
        selectList.addAll(elementVisitor.getColumns());
        if (!selectList.isEmpty()) {
            Set keys = CdsModelUtils.concreteKeyNames((CdsStructuredType)target);
            List content = (List)DataUtils.getOrDefault(data, (String)element.getName(), List.of());
            CqnPredicate filter = SelectionSetBuilder.toFilter(content, keys);
            StructuredType path = CQL.to((String)element.getName());
            if (filter != null) {
                path = path.filter(filter);
            }
            CdsModelUtils.targetKeys((CdsElement)element).stream().map(CQL::get).forEach(selectList::add);
            return List.of(path.expand(selectList));
        }
        return List.of();
    }

    private static CqnPredicate toFilter(List<Map<String, Object>> content, Set<String> keys) {
        CdsList cdsList;
        if (content instanceof CdsList && !(cdsList = (CdsList)content).isEmpty() && cdsList.isDelta()) {
            ArrayList values = new ArrayList(cdsList.size());
            List<ElementRef> references = keys.stream().map(CQL::get).toList();
            cdsList.forEach(i -> keys.forEach(k -> values.add(CQL.val(i.get(k)))));
            return CQL.comparison((CqnValue)CQL.list(references), (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.EQ, (CqnValue)CQL.list(values));
        }
        return null;
    }

    private static void addEntityIdentifier(CdsStructuredType entity, List<CqnSelectListItem> columns) {
        entity.keyElements().forEach(k -> columns.add((CqnSelectListItem)CQL.get((String)k.getName())));
        IdentifierHelper.elementsOfIdentifier((CdsAnnotatable)entity).stream().map(v -> v.as(IdentifierHelper.toIdentifierMarker(v.path()))).forEach(columns::add);
    }

    private static void addElementIdentifier(CdsElement element, List<CqnSelectListItem> columns) {
        IdentifierHelper.elementsOfIdentifier((CdsAnnotatable)element).stream().filter(r -> element.getName().equals(r.firstSegment())).map(v -> CQL.get(v.segments().stream().skip(1L).toList())).map(v -> v.as(IdentifierHelper.toIdentifierMarker(v.path()))).forEach(columns::add);
    }

    private Predicate<CdsElement> withoutAssociationToChangeLog(Predicate<CdsElement> predicate) {
        return predicate.and(e -> !Drafts.ELEMENTS.contains(e.getName())).and(e -> {
            if (e.getType().isAssociation()) {
                return !CdsAnnotations.CHANGELOG_INTERNAL_STORAGE.isTrue((CdsAnnotatable)((CdsAssociationType)e.getType().as(CdsAssociationType.class)).getTarget());
            }
            return true;
        });
    }

    private static class ChangeTrackedElementsFromType
    implements CdsVisitor {
        private final Predicate<CdsElement> isChangeTracked;
        private final Predicate<CdsElement> isCascaded;
        private final List<CqnSelectListItem> columns = new LinkedList<CqnSelectListItem>();
        private final Set<String> visitedTypes;

        private ChangeTrackedElementsFromType(Predicate<CdsElement> isChangeTracked, Predicate<CdsElement> isCascaded, Set<String> visitedTypes) {
            this.isChangeTracked = isChangeTracked;
            this.isCascaded = isCascaded;
            this.visitedTypes = visitedTypes;
        }

        public void visit(CdsEntity entity) {
            if (!this.columns.isEmpty()) {
                SelectionSetBuilder.addEntityIdentifier((CdsStructuredType)entity, this.columns);
            }
        }

        public void visit(CdsElement element) {
            if (!element.getType().isAssociation() && !element.isKey() && CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrDefault((CdsAnnotatable)element) == null) {
                if (element.getType().isSimple() && this.isChangeTracked.test(element)) {
                    this.columns.add((CqnSelectListItem)CQL.get((String)element.getName()));
                } else {
                    RelevancyChecker checker = new RelevancyChecker(this.isChangeTracked);
                    element.getType().accept((CdsVisitor)checker);
                    if (checker.getResult()) {
                        this.columns.add((CqnSelectListItem)CQL.get((String)element.getName()));
                    }
                }
            } else if (element.getType().isAssociation() && (this.isCascaded.test(element) || this.isChangeTracked.test(element))) {
                this.onAssociation(element);
            }
        }

        private void onAssociation(CdsElement element) {
            if (CdsAnnotations.CHANGELOG_INTERNAL_STORAGE.isTrue((CdsAnnotatable)element)) {
                return;
            }
            ArrayList<CqnSelectListItem> selectList = new ArrayList<CqnSelectListItem>();
            CdsAssociationType associationType = (CdsAssociationType)element.getType().as(CdsAssociationType.class);
            if (!this.visitedTypes.contains(associationType.getTarget().getQualifiedName())) {
                if (this.isCascaded.test(element)) {
                    HashSet<String> next = new HashSet<String>(this.visitedTypes);
                    next.add(associationType.getTarget().getQualifiedName());
                    ChangeTrackedElementsFromType elementVisitor = new ChangeTrackedElementsFromType(this.isChangeTracked, this.isCascaded, next);
                    associationType.getTarget().accept((CdsVisitor)elementVisitor);
                    selectList.addAll(elementVisitor.getColumns());
                }
                if (this.isChangeTracked.test(element) && (associationType.isComposition() || CdsModelUtils.isSingleValued((CdsType)associationType))) {
                    if (selectList.isEmpty()) {
                        CdsModelUtils.targetKeys((CdsElement)element).stream().map(CQL::get).forEach(selectList::add);
                    }
                    SelectionSetBuilder.addElementIdentifier(element, selectList);
                    if (!selectList.isEmpty()) {
                        this.columns.add((CqnSelectListItem)CQL.to((String)element.getName()).expand(selectList));
                    } else {
                        this.columns.add((CqnSelectListItem)CQL.get((String)element.getName()));
                    }
                } else if (!selectList.isEmpty()) {
                    this.columns.add((CqnSelectListItem)CQL.to((String)element.getName()).expand(selectList));
                }
            }
        }

        List<CqnSelectListItem> getColumns() {
            return this.columns;
        }

        private static class RelevancyChecker
        implements CdsVisitor {
            private boolean result = false;
            private final Predicate<CdsElement> isRelevant;

            private RelevancyChecker(Predicate<CdsElement> isRelevant) {
                this.isRelevant = isRelevant;
            }

            private boolean getResult() {
                return this.result;
            }

            public void visit(CdsArrayedType type) {
                type.getItemsType().accept((CdsVisitor)this);
            }

            public void visit(CdsElement element) {
                if (!this.result) {
                    this.result = this.isRelevant.test(element);
                }
            }
        }
    }
}

