/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.changetracking;

import com.sap.cds.feature.changetracking.tracking.ChangeTrackingServiceDefaultHandler;
import com.sap.cds.feature.changetracking.tracking.ChangeTrackingServiceImpl;
import com.sap.cds.feature.changetracking.tracking.ChangeViewHandler;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class ChangeTrackingConfiguration implements CdsRuntimeConfiguration {

	@Override
	public void services(CdsRuntimeConfigurer configurer) {
		configurer.service(new ChangeTrackingServiceImpl(ChangeTrackingService.DEFAULT_NAME));
	}

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		configurer.eventHandler(new ChangeTrackingPersistenceServiceHandler());
		configurer.eventHandler(new ChangeTrackingServiceDefaultHandler());
		configurer.eventHandler(new ChangeViewHandler());
	}

}
