/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.changetracking;

import com.sap.cds.Result;
import com.sap.cds.services.Service;

import java.util.List;

/**
 * Service that accepts changes and writes them to the change log storage. To write and access changelog directly
 * it is preferable to use the {@link com.sap.cds.services.persistence.PersistenceService} instead.
 */
public interface ChangeTrackingService extends Service {

	String DEFAULT_NAME = "ChangeTrackingService$Default";

	String CREATE_CHANGES = "createChanges";

	/**
	 * Writes the changes to the change log storage.
	 *
	 * @param changes the changes to be written.
	 */
	Result createChanges(List<Changes> changes);
}
