/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.changetracking;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@CdsName("sap.changelog.Changes")
@SuppressWarnings("unused")
public interface Changes extends CdsData {
	String ID = "ID";

	String CREATED_AT = "createdAt";

	String CREATED_BY = "createdBy";

	String CHANGE_LOG_ID = "changeLogID";

	String ROOT_ENTITY = "rootEntity";

	String ROOT_IDENTIFIER = "rootIdentifier";

	String ATTRIBUTE = "attribute";

	String VALUE_CHANGED_FROM = "valueChangedFrom";

	String VALUE_CHANGED_TO = "valueChangedTo";

	String VALUE_DATA_TYPE = "valueDataType";

	String TARGET_IDENTIFIER = "targetIdentifier";

	String TARGET_ENTITY = "targetEntity";

	String PATH = "path";

	String MODIFICATION = "modification";

	String MODIFICATION_TEXT = "modificationText";

	String ATTRIBUTE_TEXT = "attributeText";

	String TARGET_ENTITY_TEXT = "targetEntityText";

	String ROOT_ENTITY_TEXT = "rootEntityText";

	@CdsName(ID)
	String getId();

	@CdsName(ID)
	void setId(String id);

	Instant getCreatedAt();

	void setCreatedAt(Instant createdAt);

	/**
	 * Canonical user ID
	 */
	String getCreatedBy();

	/**
	 * Canonical user ID
	 */
	void setCreatedBy(String createdBy);

	String getChangeLogID();

	void setChangeLogID(String changeLogID);

	String getRootEntity();

	void setRootEntity(String rootEntity);

	String getRootIdentifier();

	void setRootIdentifier(String rootIdentifier);

	String getAttribute();

	void setAttribute(String attribute);

	String getValueChangedFrom();

	void setValueChangedFrom(String valueChangedFrom);

	String getValueChangedTo();

	void setValueChangedTo(String valueChangedTo);

	String getValueDataType();

	void setValueDataType(String valueDataType);

	String getTargetIdentifier();

	void setTargetIdentifier(String targetIdentifier);

	String getTargetEntity();

	void setTargetEntity(String targetEntity);

	String getPath();

	void setPath(String path);

	String getModification();

	void setModification(String modification);

	String getModificationText();

	void setModificationText(String modificationText);

	String getAttributeText();

	void setAttributeText(String attributeText);

	String getTargetEntityText();

	void setTargetEntityText(String targetEntityText);

	String getRootEntityText();

	void setRootEntityText(String rootEntityText);

	static Changes create() {
		return Struct.create(Changes.class);
	}

	static Changes create(String id) {
		Map<String, Object> keys = new HashMap<>();
		keys.put(ID, id);
		return Struct.access(keys).as(Changes.class);
	}

	final class Modification {
		public static final String CREATE = "create";

		public static final String UPDATE = "update";

		public static final String DELETE = "delete";

		private Modification() {
		}
	}
}
