/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.changetracking;

import com.sap.cds.Result;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

import java.util.List;
import java.util.Map;

@EventName(ChangeTrackingService.CREATE_CHANGES)
public interface CreateChangesEventContext extends EventContext {

	static CreateChangesEventContext create() {
		return EventContext.create(CreateChangesEventContext.class, null);
	}

	/**
	 * Sets the changes to be written to the change log storage.
	 *
	 * @param changes the changes to be written.
	 */
	void setChanges(List<Changes> changes);

	/**
	 * Returns the actual state of the changes in this context
	 *
	 * @return the changes
	 */
	List<Changes> getChanges();

	/**
	 * Returns the written changes
	 */
	Result getResult();

	/**
	 * Sets the written changes and completes the event processing
	 */
	void setResult(Iterable<? extends Map<String, ?>> result);
}
