/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.changetracking.tracking;

import java.util.function.Predicate;

import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.utils.model.CdsAnnotations;

public class ChangeTrackableElement implements Predicate<CdsElement> {

	public static final Predicate<CdsElement> IS_RELEVANT = new ChangeTrackableElement();

	private ChangeTrackableElement() {
		// hidden
	}

	@Override
	public boolean test(CdsElement element) {
		if (!SensitiveElement.IS_SENSITIVE.test(element)) {
			Object value = CdsAnnotations.CHANGELOG.getOrDefault(element);
			if (value instanceof Boolean booleanValue) {
				return booleanValue;
			} else {
				return true;
			}
		}
		return false;
	}
}
