/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.changetracking.tracking;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.sap.cds.feature.changetracking.ChangeTrackingService;
import com.sap.cds.feature.changetracking.Changes;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.persistence.PersistenceService;

class ChangeTrackerResultHandler {

	private ChangeTrackerResultHandler() {
		// hidden constructor
	}

	static void handle(EventContext context, Map<Path, List<Changes>> result) {
		if (!result.isEmpty()) {
			ChangeTrackingService changeTrackingService = context.getServiceCatalog()
					.getService(ChangeTrackingService.class, ChangeTrackingService.DEFAULT_NAME);
			changeTrackingService.createChanges(result.values().stream().flatMap(Collection::stream).toList());

			CqnService persistenceService = context.getServiceCatalog()
					.getService(CqnService.class, PersistenceService.DEFAULT_NAME);

			result.entrySet().stream().filter(e -> e.getKey().root().type().findAssociation("changes").isPresent())
					.forEach(e -> {
						List<Map<String, String>> links =
								e.getValue().stream().map(c -> Map.of("change_ID", c.getId())).toList();
						persistenceService.run(
								Insert.into(CQL.entity(e.getKey().root().type().getQualifiedName())
										.matching(e.getKey().root().keyValues()).to("changes")).entries(links));
					});
		}
	}
}
