/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.changetracking.tracking;

import com.sap.cds.feature.changetracking.ChangeTrackingService;
import com.sap.cds.feature.changetracking.Changes;
import com.sap.cds.feature.changetracking.CreateChangesEventContext;
import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.Insert;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.OrderConstants;

@ServiceName(ChangeTrackingService.DEFAULT_NAME)
public class ChangeTrackingServiceDefaultHandler implements EventHandler {
	private static final String CHANGES_ENTITY = Changes.class.getAnnotation(CdsName.class).value();

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	void writeChangeLog(CreateChangesEventContext context) {
		CqnService receiver = context.getServiceCatalog().getService(CqnService.class, PersistenceService.DEFAULT_NAME);
		context.setResult(receiver.run(Insert.into(CHANGES_ENTITY).entries(context.getChanges())));
	}
}
