/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.changetracking.tracking;

import com.sap.cds.Result;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.feature.changetracking.ChangeTrackingService;
import com.sap.cds.feature.changetracking.Changes;
import com.sap.cds.feature.changetracking.CreateChangesEventContext;

import java.util.List;

public class ChangeTrackingServiceImpl extends ServiceDelegator implements ChangeTrackingService {

	public ChangeTrackingServiceImpl(String name) {
		super(name);
	}

	@Override
	public Result createChanges(List<Changes> changes) {
		CreateChangesEventContext context = CreateChangesEventContext.create();
		context.setChanges(changes);

		emit(context);
		return context.getResult();
	}
}
