/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.changetracking.tracking;

import java.time.Instant;
import java.util.HashMap;

import com.sap.cds.feature.changetracking.Changes;
import com.sap.cds.feature.changetracking.tracking.components.IdentifierHelper;
import com.sap.cds.impl.CdsDataImpl;
import com.sap.cds.ql.cqn.Path;

class ChangesImpl extends CdsDataImpl implements Changes {

	ChangesImpl() {
		super(new HashMap<>(4));
	}

	public static Changes createFrom(Changes changes) {
		ChangesImpl result = new ChangesImpl();
		result.setModification(changes.getModification());
		result.setChangeLogID(changes.getChangeLogID());
		result.setRootIdentifier(changes.getRootIdentifier());
		result.setRootEntity(changes.getRootEntity());
		result.setTargetIdentifier(changes.getTargetIdentifier());
		result.setTargetEntity(changes.getTargetEntity());
		result.setPath(changes.getPath());

		return result;
	}

	public static Changes createFrom(Path path) {
		Changes change = new ChangesImpl();
		change.setTargetIdentifier(IdentifierHelper.getIdentifier(path.target()));
		change.setTargetEntity(path.target().entity().getQualifiedName());
		change.setPath(path.toRef().toString());
		return change;
	}

	@Override
	public String getId() {
		return (String) data.get(Changes.ID);
	}

	@Override
	public void setId(String id) {
		data.put(Changes.ID, id);
	}

	@Override
	public Instant getCreatedAt() {
		return (Instant) data.get(Changes.CREATED_AT);
	}

	@Override
	public void setCreatedAt(Instant createdAt) {
		data.put(Changes.CREATED_AT, createdAt);
	}

	@Override
	public String getCreatedBy() {
		return (String) data.get(Changes.CREATED_BY);
	}

	@Override
	public void setCreatedBy(String createdBy) {
		data.put(Changes.CREATED_BY, createdBy);
	}

	@Override
	public String getChangeLogID() {
		return (String) data.get(Changes.CHANGE_LOG_ID);
	}

	@Override
	public void setChangeLogID(String changeLogID) {
		data.put(Changes.CHANGE_LOG_ID, changeLogID);
	}

	@Override
	public String getRootEntity() {
		return (String) data.get(Changes.ROOT_ENTITY);
	}

	@Override
	public void setRootEntity(String rootEntity) {
		data.put(Changes.ROOT_ENTITY, rootEntity);
	}

	@Override
	public String getRootEntityText() {
		return (String) data.get(Changes.ROOT_ENTITY_TEXT);
	}

	@Override
	public void setRootEntityText(String rootEntityText) {
		data.put(Changes.ROOT_ENTITY_TEXT, rootEntityText);
	}

	@Override
	public String getRootIdentifier() {
		return (String) data.get(Changes.ROOT_IDENTIFIER);
	}

	@Override
	public void setRootIdentifier(String rootIdentifier) {
		data.put(Changes.ROOT_IDENTIFIER, rootIdentifier);
	}

	@Override
	public String getAttribute() {
		return (String) data.get(Changes.ATTRIBUTE);
	}

	@Override
	public void setAttribute(String attribute) {
		data.put(Changes.ATTRIBUTE, attribute);
	}

	@Override
	public String getAttributeText() {
		return data.get(Changes.ATTRIBUTE_TEXT).toString();
	}

	@Override
	public void setAttributeText(String attributeText) {
		data.put(Changes.ATTRIBUTE_TEXT, attributeText);
	}

	@Override
	public String getValueChangedFrom() {
		return (String) data.get(Changes.VALUE_CHANGED_FROM);
	}

	@Override
	public void setValueChangedFrom(String valueChangedFrom) {
		data.put(Changes.VALUE_CHANGED_FROM, valueChangedFrom);
	}

	@Override
	public String getValueChangedTo() {
		return (String) data.get(Changes.VALUE_CHANGED_TO);
	}

	@Override
	public void setValueChangedTo(String valueChangedTo) {
		data.put(Changes.VALUE_CHANGED_TO, valueChangedTo);
	}

	@Override
	public String getValueDataType() {
		return (String) data.get(Changes.VALUE_DATA_TYPE);
	}

	@Override
	public void setValueDataType(String valueDataType) {
		data.put(Changes.VALUE_DATA_TYPE, valueDataType);
	}

	@Override
	public String getTargetIdentifier() {
		return (String) data.get(Changes.TARGET_IDENTIFIER);
	}

	@Override
	public void setTargetIdentifier(String targetIdentifier) {
		data.put(Changes.TARGET_IDENTIFIER, targetIdentifier);
	}

	@Override
	public String getTargetEntity() {
		return (String) data.get(Changes.TARGET_ENTITY);
	}

	@Override
	public void setTargetEntity(String targetEntity) {
		data.put(Changes.TARGET_ENTITY, targetEntity);
	}

	@Override
	public String getTargetEntityText() {
		return (String) data.get(Changes.TARGET_ENTITY_TEXT);
	}

	@Override
	public void setTargetEntityText(String targetEntityText) {
		data.put(Changes.TARGET_ENTITY_TEXT, targetEntityText);
	}

	@Override
	public String getPath() {
		return (String) data.get(Changes.PATH);
	}

	@Override
	public void setPath(String path) {
		data.put(Changes.PATH, path);
	}

	@Override
	public String getModification() {
		return (String) data.get(Changes.MODIFICATION);
	}

	@Override
	public void setModification(String modification) {
		data.put(Changes.MODIFICATION, modification);
	}

	@Override
	public String getModificationText() {
		return (String) data.get(Changes.MODIFICATION_TEXT);
	}

	@Override
	public void setModificationText(String modificationText) {
		data.put(Changes.MODIFICATION_TEXT, modificationText);
	}
}
