/*********************************************************************
 * (C) 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.feature.changetracking.tracking;

import java.util.function.Predicate;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.services.utils.model.CdsAnnotations;

public class SensitiveElement implements Predicate<CdsAnnotatable> {

	public static final Predicate<CdsAnnotatable> IS_SENSITIVE = new SensitiveElement();

	private SensitiveElement() {
		// hidden
	}

	@Override
	public boolean test(CdsAnnotatable annotatable) {
		return CdsAnnotations.PERSONALDATA_POTENTIALLYPERSONAL.isTrue(annotatable)
			|| CdsAnnotations.PERSONALDATA_POTENTIALLYSENSITIVE.isTrue(annotatable);
	}
}
