/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking;

import com.sap.cds.feature.changetracking.tracking.ChangesToPresentationConverter;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ChangeViewHandler
implements EventHandler {
    @Before(entity={"*"})
    @HandlerOrder(value=-10500)
    void checkChangesAccess(CdsReadEventContext context) {
        AnalysisResult result;
        CdsEntity root;
        CdsEntity target = context.getTarget();
        if (CdsAnnotations.AUTOEXPOSED.isTrue((CdsAnnotatable)target) && CdsAnnotations.CHANGELOG_INTERNAL_STORAGE.isTrue((CdsAnnotatable)target) && CdsAnnotations.CHANGELOG_INTERNAL_STORAGE.isTrue((CdsAnnotatable)(root = (result = CqnAnalyzer.create((CdsModel)context.getModel()).analyze((CqnFilterableStatement)context.getCqn())).rootEntity()))) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_READABLE, new Object[]{context.getTarget().getQualifiedName()});
        }
    }

    @After(entity={"*"})
    @HandlerOrder(value=-11000)
    void extendChangeView(CdsReadEventContext context) {
        if (ChangeViewHandler.requiresConversion(context)) {
            final ChangesToPresentationConverter converter = new ChangesToPresentationConverter((EventContext)context);
            DataProcessor.create().action(new DataProcessor.Action(){

                public void entry(Path path, CdsElement element, CdsStructuredType type, Map<String, Object> entry) {
                    type.elements().filter(e -> CdsAnnotations.CHANGELOG_INTERNAL_SEMANTICS.getOrValue((CdsAnnotatable)e, null) != null && entry.containsKey(e.getName())).forEach(e -> {
                        String semantics = (String)CdsAnnotations.CHANGELOG_INTERNAL_SEMANTICS.getOrValue((CdsAnnotatable)e, (Object)"");
                        Optional<String> s = ChangeViewHandler.resolveTextElement(e);
                        if (s.isPresent()) {
                            switch (semantics) {
                                case "modification": {
                                    entry.computeIfAbsent(s.get(), k -> converter.convertModification((CdsElement)e, entry.get(e.getName())));
                                    break;
                                }
                                case "rootEntity": 
                                case "targetEntity": {
                                    entry.computeIfAbsent(s.get(), k -> converter.convertEntityName(entry.get(e.getName())));
                                    break;
                                }
                                case "attribute": {
                                    entry.computeIfAbsent(s.get(), k -> {
                                        Optional<CdsElement> targetEntity = type.elements().filter(t -> ((String)CdsAnnotations.CHANGELOG_INTERNAL_SEMANTICS.getOrValue((CdsAnnotatable)t, (Object)"")).equals("targetEntity")).findFirst();
                                        if (targetEntity.isPresent()) {
                                            return converter.convertAttribute(entry.get(targetEntity.get().getName()), entry.get(e.getName()));
                                        }
                                        return entry.get(e.getName());
                                    });
                                    break;
                                }
                            }
                        }
                    });
                }
            }).addConverter((path, element, type) -> ChangesToPresentationConverter.isChangeLogElement(element, "path"), (path, element, value) -> {
                if (value instanceof String) {
                    String string = (String)value;
                    return converter.convertPath(string);
                }
                return value;
            }).process(context.getResult());
        }
    }

    private static Optional<String> resolveTextElement(CdsElement element) {
        return Optional.ofNullable(((Map)CdsAnnotations.COMMON_TEXT.getOrValue((CdsAnnotatable)element, Map.of())).get("=")).map(Object::toString);
    }

    private static boolean requiresConversion(CdsReadEventContext context) {
        CdsEntity target = context.getTarget();
        Object value = CdsAnnotations.CHANGELOG_INTERNAL_ENRICH.getOrValue((CdsAnnotatable)target, null);
        if (value != null) {
            return Boolean.TRUE.equals(value);
        }
        TargetsAssociation targetsAssociation = new TargetsAssociation(arg_0 -> ((CdsAnnotations)CdsAnnotations.CHANGELOG_INTERNAL_ENRICH).isTrue(arg_0), (CdsStructuredType)context.getTarget());
        context.getCqn().accept((CqnVisitor)targetsAssociation);
        return targetsAssociation.getResult();
    }

    private static class TargetsAssociation
    implements CqnVisitor {
        private final Predicate<CdsStructuredType> condition;
        private final CdsStructuredType target;
        private boolean result = false;

        private TargetsAssociation(Predicate<CdsStructuredType> condition, CdsStructuredType target) {
            this.condition = condition;
            this.target = target;
        }

        public void visit(CqnInline inline) {
            CdsStructuredType assocTarget;
            if (!this.result && this.condition.test(assocTarget = CdsModelUtils.target((CdsStructuredType)this.target, (List)inline.ref().segments()))) {
                this.result = true;
            }
        }

        public void visit(CqnExpand expand) {
            if (!this.result && !expand.ref().rootSegment().id().equals("*")) {
                CdsStructuredType assocTarget = CdsModelUtils.target((CdsStructuredType)this.target, (List)expand.ref().segments());
                if (this.condition.test(assocTarget)) {
                    this.result = true;
                }
                expand.items().forEach(i -> {
                    if (!this.result) {
                        TargetsAssociation targetsAssociation = new TargetsAssociation(this.condition, assocTarget);
                        i.accept((CqnVisitor)targetsAssociation);
                        this.result = targetsAssociation.getResult();
                    }
                });
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

