/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking;

import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

final class RefSerializer {
    private RefSerializer() {
    }

    public static String serialize(CqnStructuredTypeRef ref) {
        if (ref == null || ref.segments().isEmpty()) {
            return "";
        }
        List segments = ref.segments();
        ArrayList<String> target = new ArrayList<String>(ref.segments().size());
        for (CqnReference.Segment segment : segments) {
            Object result = segment.id();
            Optional filter = segment.filter();
            if (filter.isPresent()) {
                FilterSerializer serializer = new FilterSerializer();
                ((CqnPredicate)filter.get()).accept((CqnVisitor)serializer);
                if (!serializer.isEmpty()) {
                    result = (String)result + serializer.getResult();
                }
            }
            target.add((String)result);
        }
        return String.join((CharSequence)"/", target);
    }

    private static class FilterSerializer
    implements CqnVisitor {
        private final List<String> filterString = new ArrayList<String>(3);
        private final List<String> draftKeys = new ArrayList<String>(1);

        private FilterSerializer() {
        }

        public void visit(CqnComparisonPredicate predicate) {
            if (predicate.operator() == CqnComparisonPredicate.Operator.EQ || predicate.operator() == CqnComparisonPredicate.Operator.IS) {
                CqnValue left = predicate.left();
                CqnValue right = predicate.right();
                CqnValue value = null;
                String key = null;
                if (left instanceof CqnElementRef) {
                    CqnElementRef leftRef = (CqnElementRef)left;
                    key = leftRef.firstSegment();
                    value = right;
                }
                if (key != null) {
                    CqnLiteral literal;
                    Object theValue = null;
                    if (value instanceof CqnLiteral && (theValue = (literal = (CqnLiteral)value).value()) instanceof String) {
                        String stringValue = (String)theValue;
                        theValue = "'" + stringValue + "'";
                    }
                    if (theValue != null) {
                        if (key.equals("IsActiveEntity")) {
                            this.draftKeys.add(0, key + "=" + theValue);
                        } else {
                            this.filterString.add(key + "=" + theValue);
                        }
                    }
                }
            }
        }

        public boolean isEmpty() {
            return this.filterString.isEmpty();
        }

        public String getResult() {
            this.filterString.addAll(this.draftKeys);
            return "(" + String.join((CharSequence)",", this.filterString) + ")";
        }
    }
}

