/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.CdsDiffProcessor;
import com.sap.cds.CdsList;
import com.sap.cds.feature.changetracking.Changes;
import com.sap.cds.feature.changetracking.tracking.ChangeTrackerResultHandler;
import com.sap.cds.feature.changetracking.tracking.ChangesImpl;
import com.sap.cds.feature.changetracking.tracking.components.IdentifierHelper;
import com.sap.cds.impl.diff.DiffProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.impl.PathImpl;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.EventContext;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class ChangeTracker
implements CdsDiffProcessor.DiffVisitor,
CdsDataProcessor.Filter {
    private final Predicate<CdsElement> isRelevant;
    private final Map<Path, List<Changes>> changedElements = new HashMap<Path, List<Changes>>();
    private final Map<Path, List<Changes>> changedAssociations = new HashMap<Path, List<Changes>>();

    public ChangeTracker(Predicate<CdsElement> isRelevant) {
        this.isRelevant = isRelevant;
    }

    public static void apply(EventContext context, Predicate<CdsElement> isRelevant, Collection<? extends Map<String, Object>> newImage, Collection<? extends Map<String, Object>> oldImage) {
        ChangeTracker changeTracker = new ChangeTracker(isRelevant);
        DiffProcessor.create().forDeepTraversal().add((CdsDataProcessor.Filter)changeTracker, (CdsDiffProcessor.DiffVisitor)changeTracker).process(newImage, oldImage, (CdsStructuredType)context.getTarget());
        ChangeTrackerResultHandler.handle(context, changeTracker.result());
    }

    public boolean test(Path path, CdsElement element, CdsType type) {
        return element == null || element.getType().isAssociation() || this.isChangeTrackedAssociation(path.target().element()) || this.isRelevant.test(element);
    }

    public void changed(Path newPath, Path oldPath, CdsElement element, Object newValue, Object oldValue) {
        CdsElement association = newPath.target().element();
        if (element.isKey() && this.isChangeTrackedAssociation(association) && !IdentifierHelper.elementsOfIdentifier((CdsAnnotatable)association).isEmpty()) {
            if (!this.changedAssociations.containsKey(newPath)) {
                Changes change = ChangesImpl.createFrom(ChangeTracker.pathToParent(newPath));
                change.setValueDataType(CdsBaseType.STRING.cdsName());
                change.setAttribute(newPath.target().element().getName());
                change.setModification("update");
                Object newIdentifier = Objects.requireNonNullElse(IdentifierHelper.getIdentifier(association, newPath.target().values()), newValue);
                Object oldIdentifier = Objects.requireNonNullElse(IdentifierHelper.getIdentifier(association, oldPath.target().values()), oldValue);
                ChangeTracker.consume(oldIdentifier, change::setValueChangedFrom);
                ChangeTracker.consume(newIdentifier, change::setValueChangedTo);
                this.push(this.changedAssociations, newPath, List.of(change));
            }
        } else {
            Changes change;
            if (this.changedElements.containsKey(newPath)) {
                Changes template = this.changedElements.get(newPath).get(0);
                change = ChangesImpl.createFrom(template);
            } else {
                change = ChangesImpl.createFrom(newPath);
                change.setPath(newPath.toRef().toString());
                change.setModification("update");
            }
            change.setAttribute(element.getName());
            change.setValueDataType(element.getType().getQualifiedName());
            ChangeTracker.consume(oldValue, change::setValueChangedFrom);
            ChangeTracker.consume(newValue, change::setValueChangedTo);
            this.push(this.changedElements, newPath, List.of(change));
        }
    }

    public void added(Path newPath, Path oldPath, CdsElement association, Map<String, Object> newValue) {
        this.onAssociationChange(newPath, oldPath, association, newValue, (c, v) -> {
            c.setModification("create");
            ChangeTracker.consume(v, c::setValueChangedTo);
        });
    }

    public void removed(Path newPath, Path oldPath, CdsElement association, Map<String, Object> oldValue) {
        this.onAssociationChange(newPath, oldPath, association, oldValue, (c, v) -> {
            c.setModification("delete");
            ChangeTracker.consume(v, c::setValueChangedFrom);
        });
    }

    private Map<Path, List<Changes>> result() {
        String changeLogId = UUID.randomUUID().toString();
        HashMap<Path, List<Changes>> result = new HashMap<Path, List<Changes>>();
        Stream.concat(this.changedElements.entrySet().stream(), this.changedAssociations.entrySet().stream()).forEach(e -> {
            String rootEntity = ((Path)e.getKey()).root().type().getQualifiedName();
            String rootIdentifier = IdentifierHelper.getIdentifier(((Path)e.getKey()).root());
            ((List)e.getValue()).forEach(item -> {
                item.setId(UUID.randomUUID().toString());
                item.setRootEntity(rootEntity);
                item.setRootIdentifier(rootIdentifier);
                item.setChangeLogID(changeLogId);
            });
            result.computeIfAbsent((Path)e.getKey(), s -> new ArrayList()).addAll((Collection)e.getValue());
        });
        return result;
    }

    private void onAssociationChange(Path newPath, Path oldPath, CdsElement association, Map<String, Object> state, BiConsumer<Changes, Object> action) {
        if (this.isChangeTrackedAssociation(association)) {
            String identifier = IdentifierHelper.getIdentifier(association, state);
            if (identifier != null) {
                Path pathWithValues = ChangeTracker.selectPathWithValues(newPath, oldPath);
                Changes associationChange = ChangesImpl.createFrom(pathWithValues);
                associationChange.setValueDataType(CdsBaseType.STRING.cdsName());
                associationChange.setAttribute(association.getName());
                action.accept(associationChange, identifier);
                this.push(this.changedAssociations, pathWithValues, List.of(associationChange));
            } else {
                Path extendedPath = this.extendPath(ChangeTracker.selectPathWithValues(newPath, oldPath), association, state);
                Set keys = CdsModelUtils.targetKeys((CdsElement)association);
                this.push(this.changedElements, extendedPath, this.handleAssociation(extendedPath, state, e -> keys.contains(e.getName()), action));
            }
        }
        Path extendedPath = this.extendPath(ChangeTracker.selectPathWithValues(newPath, oldPath), association, state);
        this.push(this.changedElements, extendedPath, this.handleAssociation(extendedPath, state, this.isRelevant, action));
    }

    private Path extendPath(Path from, CdsElement association, Map<String, Object> state) {
        if (association != null) {
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            return ((PathImpl)from).append(association, (CdsStructuredType)target, state);
        }
        return new PathImpl(new LinkedList()).append(null, from.target().type(), state);
    }

    private static void consume(Object value, Consumer<String> setter) {
        if (value != null) {
            if (value instanceof Map) {
                Map map = (Map)value;
                setter.accept(CdsData.create((Map)map).toJson());
            } else if (value instanceof List) {
                List collection = (List)value;
                setter.accept(CdsList.create((List)collection).toJson());
            } else {
                setter.accept(value.toString());
            }
        }
    }

    private void push(Map<Path, List<Changes>> result, Path path, List<Changes> changes) {
        if (!changes.isEmpty()) {
            result.computeIfAbsent(path, s -> new ArrayList()).addAll(changes);
        }
    }

    private List<Changes> handleAssociation(Path path, Map<String, Object> state, Predicate<CdsElement> takeIf, BiConsumer<Changes, Object> action) {
        LinkedList<Changes> result = new LinkedList<Changes>();
        Changes template = ChangesImpl.createFrom(path);
        template.setTargetIdentifier(IdentifierHelper.getIdentifier(path.target()));
        template.setPath(path.toRef().toString());
        state.entrySet().stream().filter(e -> e.getValue() != null && path.target().type().findElement((String)e.getKey()).isPresent()).forEach(item -> {
            CdsElement element = path.target().type().getElement((String)item.getKey());
            if (!element.getType().isAssociation() && takeIf.test(element) && element.getDeclaringType().getKind().equals((Object)CdsKind.ENTITY)) {
                Changes change = ChangesImpl.createFrom(template);
                change.setAttribute(element.getName());
                change.setValueDataType(element.getType().getQualifiedName());
                action.accept(change, item.getValue());
                result.add(change);
            }
        });
        return result;
    }

    private static Path selectPathWithValues(Path newPath, Path oldPath) {
        return newPath.target().values().isEmpty() ? oldPath : newPath;
    }

    private boolean isChangeTrackedAssociation(CdsElement association) {
        return association != null && (association.getType().isAssociation() && CdsModelUtils.isSingleValued((CdsType)association.getType()) || ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).isComposition()) && this.isRelevant.test(association);
    }

    private static Path pathToParent(Path from) {
        return new PathImpl(StreamSupport.stream(from.spliterator(), false).takeWhile(s -> !s.equals(from.target())).collect(Collectors.toCollection(LinkedList::new)));
    }
}

