/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.cds.adapter.edmx.EdmxI18nProvider;
import com.sap.cds.feature.changetracking.tracking.RefSerializer;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.TokenParser;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEnumType;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangesToPresentationConverter {
    private static final Logger logger = LoggerFactory.getLogger(ChangesToPresentationConverter.class);
    private static final Pattern I18N_KEY = Pattern.compile("\\{i18n>(.+)\\}");
    private final CdsModel model;
    private final Map<String, String> texts;

    ChangesToPresentationConverter(EventContext context) {
        this.model = context.getModel();
        EdmxI18nProvider provider = (EdmxI18nProvider)context.getCdsRuntime().getProvider(EdmxI18nProvider.class);
        this.texts = provider != null ? provider.getTexts(context.getParameterInfo().getLocale()) : Collections.emptyMap();
    }

    public Object convertModification(CdsElement element, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            CdsEnumType cdsEnumType = (CdsEnumType)element.getType().as(CdsEnumType.class);
            Map enumItems = cdsEnumType.enumerals();
            if (enumItems.containsKey(string)) {
                return this.getTitleOrDefault((CdsAnnotatable)enumItems.get(string), string);
            }
        }
        return value;
    }

    public Object convertEntityName(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return this.model.findEntity(string).map(e -> this.getTitleOrDefault((CdsAnnotatable)e, string)).orElse(string);
        }
        return value;
    }

    public Object convertAttribute(Object entity, Object value) {
        if (entity instanceof String) {
            String entityName = (String)entity;
            if (value instanceof String) {
                String attributeName = (String)value;
                return this.model.findEntity(entityName).flatMap(e -> e.findElement(attributeName)).map(element -> this.getTitleOrDefault((CdsAnnotatable)element, attributeName)).orElse(attributeName);
            }
        }
        return value;
    }

    public Object convertPath(Object value) {
        if (value instanceof String) {
            String path = (String)value;
            try {
                StructuredTypeRef ref = TokenParser.ref((JsonNode)JsonParser.parseJson((String)path));
                return this.model.findEntity(ref.rootSegment().id()).map(r -> RefSerializer.serialize((CqnStructuredTypeRef)ref)).orElse(path);
            }
            catch (Exception e) {
                logger.warn("Failed to parse value of the path in the changelog, the original value will be returned");
            }
        }
        return value;
    }

    private String getTitleOrDefault(CdsAnnotatable from, String defaultValue) {
        String title = (String)CdsAnnotations.TITLE.getOrValue(from, (Object)((String)CdsAnnotations.COMMON_LABEL.getOrValue(from, (Object)defaultValue)));
        if (!this.texts.isEmpty()) {
            Matcher matcher = I18N_KEY.matcher(title);
            if (matcher.matches()) {
                String key = matcher.group(1);
                return this.texts.getOrDefault(key, defaultValue);
            }
            return title;
        }
        return defaultValue;
    }

    public static boolean isChangeLogElement(CdsElement element, String attribute) {
        return CdsAnnotations.CHANGELOG_INTERNAL_SEMANTICS.getOrDefault((CdsAnnotatable)element).equals(attribute);
    }
}

