/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking.components;

import com.sap.cds.feature.changetracking.tracking.SensitiveElement;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.draft.Drafts;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.DataUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class IdentifierHelper {
    private static final String READABLE_ID = "@ctid:";

    private IdentifierHelper() {
    }

    public static String toIdentifierMarker(String id) {
        return READABLE_ID + StringUtils.replace((String)id, (String)".", (String)"_");
    }

    public static List<ElementRef<Object>> elementsOfIdentifier(CdsAnnotatable type) {
        CdsStructuredType target;
        Object value = CdsAnnotations.CHANGELOG.getOrValue(type, null);
        if (value instanceof Boolean) {
            return List.of();
        }
        List<String> members = ((List)CdsAnnotations.CHANGELOG.getOrValue(type, List.of())).stream().flatMap(v -> v.values().stream().map(Object::toString)).filter(e -> !Drafts.ELEMENTS.contains(e)).toList();
        LinkedList<ElementRef<Object>> result = new LinkedList<ElementRef<Object>>();
        String prefix = null;
        if (type instanceof CdsElement) {
            CdsElement def = (CdsElement)type;
            prefix = def.getName();
            target = (CdsStructuredType)def.getDeclaringType();
        } else {
            target = (CdsStructuredType)type;
        }
        for (String k : members) {
            Optional element;
            ElementRef ref = CQL.get((String)k);
            if (prefix != null && !prefix.equals(ref.firstSegment()) || !(element = target.findElement(k)).isPresent() || SensitiveElement.IS_SENSITIVE.test((CdsAnnotatable)element.get())) continue;
            result.add((ElementRef<Object>)ref);
        }
        return result;
    }

    public static String getIdentifier(ResolvedSegment segment) {
        Stream<Object> source = IdentifierHelper.elementsOfIdentifier((CdsAnnotatable)segment.type()).stream().map(e -> DataUtils.getOrDefault((Map)segment.values(), (String)IdentifierHelper.toIdentifierMarker(e.path()), null));
        return IdentifierHelper.stringify(source);
    }

    public static String getIdentifier(CdsElement element, Map<String, Object> values) {
        List<ElementRef<Object>> elementRefs = IdentifierHelper.elementsOfIdentifier((CdsAnnotatable)element);
        if (elementRefs.isEmpty()) {
            return null;
        }
        Stream<Object> source = elementRefs.stream().map(v -> CQL.get(v.segments().stream().skip(1L).toList())).map(e -> DataUtils.getOrDefault((Map)values, (String)IdentifierHelper.toIdentifierMarker(e.path()), null));
        return IdentifierHelper.stringify(source);
    }

    private static String stringify(Stream<Object> stream) {
        return stream.filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", "));
    }
}

