/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking;

import com.sap.cds.feature.changetracking.ChangeTrackingService;
import com.sap.cds.feature.changetracking.Changes;
import com.sap.cds.feature.changetracking.tracking.components.EntityRootReader;
import com.sap.cds.feature.changetracking.tracking.components.IdentifierHelper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.ql.impl.PathImpl;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.ProjectionResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class ChangeTrackerResultHandler {
    private static final String ASSOCIATION_TO_CHANGES = "changes";

    private ChangeTrackerResultHandler() {
    }

    static void handle(EventContext context, EntityRootReader.Root root, Stream<Map.Entry<Path, List<Changes>>> changes) {
        String changeLogId = UUID.randomUUID().toString();
        HashMap<ResolvedSegment, List> result = new HashMap<ResolvedSegment, List>();
        changes.forEach(e -> {
            Path path = root != null ? ChangeTrackerResultHandler.merge(root.path(), (Path)e.getKey()) : (Path)e.getKey();
            String rootEntity = path.root().type().getQualifiedName();
            String rootIdentifier = root != null ? root.identifier() : IdentifierHelper.getIdentifier(path.root().type(), (Map<String, Object>)path.root().values());
            ((List)e.getValue()).forEach(item -> {
                item.setPath(path.toRef().toString());
                item.setId(UUID.randomUUID().toString());
                item.setRootEntity(rootEntity);
                item.setRootIdentifier(rootIdentifier);
                item.setChangeLogID(changeLogId);
            });
            Optional<Map.Entry> first = result.entrySet().stream().filter(f -> ((ResolvedSegment)f.getKey()).type().equals(path.root().type()) && ((ResolvedSegment)f.getKey()).keyValues().equals(path.root().keyValues())).findFirst();
            if (first.isEmpty()) {
                result.put(path.root(), new ArrayList((Collection)e.getValue()));
            } else {
                ((List)first.get().getValue()).addAll((Collection)e.getValue());
            }
        });
        if (!result.isEmpty()) {
            ChangeTrackingService changeTrackingService = (ChangeTrackingService)context.getServiceCatalog().getService(ChangeTrackingService.class, "ChangeTrackingService$Default");
            changeTrackingService.createChanges(result.values().stream().flatMap(Collection::stream).toList());
            if (context.get("cqn") instanceof CqnDelete) {
                long size;
                long l = size = root != null ? StreamSupport.stream(root.path().spliterator(), false).count() : 1L;
                if (size == 1L) {
                    return;
                }
            }
            result.forEach((k, v) -> ChangeTrackerResultHandler.writeLinks(context, k, v));
        }
    }

    private static Path merge(Path prefix, Path path) {
        PathImpl result = new PathImpl(new LinkedList());
        for (ResolvedSegment next : prefix) {
            if (next == prefix.target()) continue;
            result = result.append(next.element(), next.type(), next.values());
        }
        Iterator iterator = path.iterator();
        iterator.next();
        result = result.append(prefix.target().element(), prefix.target().type(), path.root().values());
        while (iterator.hasNext()) {
            ResolvedSegment next;
            next = (ResolvedSegment)iterator.next();
            result = result.append(next.element(), next.type(), next.values());
        }
        return result;
    }

    private static void writeLinks(EventContext context, ResolvedSegment target, List<Changes> changes) {
        PersistenceService persistenceService = (PersistenceService)context.getService();
        if (target.type().findAssociation(ASSOCIATION_TO_CHANGES).isPresent()) {
            CqnReference.Segment root = target.segment();
            ChangeTrackerResultHandler.setLinks(persistenceService, root, changes);
        } else {
            ProjectionResolver resolver = ProjectionResolver.create((CdsModel)context.getModel(), (CqnStatement)Insert.into((StructuredType)CQL.to(List.of(target.segment()))));
            CqnStructuredTypeRef domainRef = ((Insert)resolver.resolveAll().getResolvedStatement()).ref();
            CdsEntity domainEntity = CdsModelUtils.entity((CdsModel)context.getModel(), (CqnStructuredTypeRef)domainRef);
            if (domainEntity.findAssociation(ASSOCIATION_TO_CHANGES).isPresent()) {
                CqnReference.Segment root = domainRef.rootSegment();
                ChangeTrackerResultHandler.setLinks(persistenceService, root, changes);
            }
        }
    }

    private static void setLinks(PersistenceService persistenceService, CqnReference.Segment target, List<Changes> changes) {
        persistenceService.run((CqnInsert)Insert.into((StructuredType)CQL.to(List.of(target)).to(ASSOCIATION_TO_CHANGES)).entries(changes.stream().map(c -> Map.of("change_ID", c.getId())).toList()));
    }
}

