/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking;

import com.sap.cds.Result;
import com.sap.cds.feature.changetracking.tracking.ChangeTrackableElement;
import com.sap.cds.feature.changetracking.tracking.ChangeTracker;
import com.sap.cds.feature.changetracking.tracking.components.ContextParameterHelper;
import com.sap.cds.feature.changetracking.tracking.components.EntityRootReader;
import com.sap.cds.feature.changetracking.tracking.components.EntityStateReader;
import com.sap.cds.feature.changetracking.tracking.components.TrackingImage;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.function.Supplier;

@ServiceName(value={"*"}, type={PersistenceService.class})
class ChangeTrackingPersistenceServiceHandler
implements EventHandler {
    private final EntityStateReader reader = new EntityStateReader(ChangeTrackableElement.IS_RELEVANT);

    ChangeTrackingPersistenceServiceHandler() {
    }

    @After
    @HandlerOrder(value=-10800)
    void afterCreate(CdsCreateEventContext context, CqnStructuredTypeRef ref) {
        ChangeTrackingPersistenceServiceHandler.track((EventContext)context, context.getResult(), () -> new TrackingImage(this.reader.newImage(context), EntityRootReader.read((EventContext)context, ref)));
    }

    @Before
    @HandlerOrder(value=11200)
    void beforeUpdate(CdsUpdateEventContext context) {
        ChangeTrackingPersistenceServiceHandler.fetch((EventContext)context, () -> new TrackingImage(this.reader.oldImage(context), null));
    }

    @After
    @HandlerOrder(value=-10800)
    void afterUpdate(CdsUpdateEventContext context, CqnStructuredTypeRef ref) {
        ChangeTrackingPersistenceServiceHandler.track((EventContext)context, context.getResult(), () -> new TrackingImage(this.reader.newImage(context), EntityRootReader.read((EventContext)context, ref)));
    }

    @Before
    @HandlerOrder(value=11200)
    void beforeUpsert(CdsUpsertEventContext context) {
        ChangeTrackingPersistenceServiceHandler.fetch((EventContext)context, () -> new TrackingImage(this.reader.oldImage(context), null));
    }

    @After
    @HandlerOrder(value=-10800)
    void afterUpsert(CdsUpsertEventContext context, CqnStructuredTypeRef ref) {
        ChangeTrackingPersistenceServiceHandler.track((EventContext)context, context.getResult(), () -> new TrackingImage(this.reader.newImage(context), EntityRootReader.read((EventContext)context, ref)));
    }

    @Before
    @HandlerOrder(value=11200)
    void beforeDelete(CdsDeleteEventContext context, CqnStructuredTypeRef ref) {
        ChangeTrackingPersistenceServiceHandler.fetch((EventContext)context, () -> new TrackingImage(this.reader.oldImage(context), EntityRootReader.read((EventContext)context, ref)));
    }

    @After
    @HandlerOrder(value=-10800)
    void afterDelete(CdsDeleteEventContext context) {
        ChangeTrackingPersistenceServiceHandler.track((EventContext)context, context.getResult(), () -> TrackingImage.EMPTY);
    }

    private static void wipeContext(EventContext context) {
        ContextParameterHelper.checkInImage(context, null);
    }

    private static void fetch(EventContext context, Supplier<TrackingImage> image) {
        CdsEntity target = context.getTarget();
        if (ChangeTrackingPersistenceServiceHandler.isNotTechnicalEntity(target)) {
            TrackingImage oldImage = image.get();
            ContextParameterHelper.checkInImage(context, oldImage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void track(EventContext context, Result result, Supplier<TrackingImage> image) {
        try {
            CdsEntity target;
            if (result != null && result.rowCount() > 0L && ChangeTrackingPersistenceServiceHandler.isNotTechnicalEntity(target = context.getTarget())) {
                TrackingImage oldImage = ContextParameterHelper.checkOutImage(context);
                TrackingImage newImage = image.get();
                if (!oldImage.content().isEmpty() || !newImage.content().isEmpty()) {
                    ChangeTracker.apply(context, ChangeTrackableElement.IS_RELEVANT, newImage, oldImage);
                }
            }
        }
        finally {
            ChangeTrackingPersistenceServiceHandler.wipeContext(context);
        }
    }

    private static boolean isNotTechnicalEntity(CdsEntity target) {
        String qualifiedName = target.getQualifiedName();
        return !qualifiedName.endsWith("DraftAdministrativeData") && !qualifiedName.endsWith("_drafts") && !qualifiedName.equals("cds.outbox.Messages") && !CdsAnnotations.CHANGELOG_INTERNAL_STORAGE.isTrue((CdsAnnotatable)target);
    }
}

