/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.changetracking.tracking.components;

import com.sap.cds.Result;
import com.sap.cds.feature.changetracking.tracking.components.DataReader;
import com.sap.cds.feature.changetracking.tracking.components.IdentifierHelper;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.EventContext;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EntityRootReader {
    private EntityRootReader() {
    }

    public static Root read(EventContext context, CqnStructuredTypeRef ref) {
        if (ref.size() > 1) {
            AnalysisResult path = CqnAnalyzer.create((CdsModel)context.getModel()).analyze(ref);
            boolean validRoot = EntityRootReader.isValidRoot((Path)path);
            if (!validRoot) {
                return null;
            }
            if (!IdentifierHelper.elementsOfIdentifier((CdsAnnotatable)path.root().type()).isEmpty()) {
                List<CqnSelectListItem> columnList = IdentifierHelper.selectIdentifier(path.root().type());
                Result r = DataReader.read(context, (CqnSelect)Select.from((StructuredType)CQL.to(List.of(path.root().segment()))).columns(columnList), Map.of());
                if (r.rowCount() == 0L) {
                    return null;
                }
                return new Root((Path)path, IdentifierHelper.getIdentifier(path.root().type(), (Map<String, Object>)r.single()));
            }
            return new Root((Path)path, null);
        }
        return null;
    }

    private static boolean isValidRoot(Path path) {
        Iterator iterator = path.iterator();
        Map keys = null;
        while (iterator.hasNext()) {
            ResolvedSegment segment = (ResolvedSegment)iterator.next();
            if (EntityRootReader.isSameDocument(segment)) {
                Map next;
                if (segment.element() != null) {
                    next = new OnConditionAnalyzer(segment.element(), true).getFkValues(keys, true);
                    next.putAll(segment.keyValues());
                } else {
                    next = segment.keyValues();
                }
                if (next.containsValue(null)) {
                    return false;
                }
                keys = next;
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean isSameDocument(ResolvedSegment segment) {
        if (segment.element() != null) {
            CdsType type = segment.element().getType();
            if (type.isAssociation()) {
                CdsAssociationType associationType = (CdsAssociationType)type.as(CdsAssociationType.class);
                return associationType.isComposition() || associationType.isEnclosed();
            }
            return true;
        }
        return segment.element() == null;
    }

    public record Root(Path path, String identifier) {
    }
}

