package com.sap.cds.feature.cloudfoundry;

import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.environment.ApplicationInfoProvider;
import com.sap.cds.services.utils.environment.VcapApplicationParser;

/**
 * Provides {@link ApplicationInfo} based on CloudFoundry's VCAP_APPLICATION
 */
public class CloudFoundryApplicationInfoProvider implements ApplicationInfoProvider {

	private ApplicationInfo applicationInfo;

	@Override
	public ApplicationInfo get() {
		if(applicationInfo == null) {
			applicationInfo = VcapApplicationParser.getApplicationInfo(System.getenv(VcapApplicationParser.VCAP_APPLICATION));
		}
		return applicationInfo;
	}

}
