/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.feature.cloudfoundry;

import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.environment.VcapApplicationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudFoundryEnvironmentConfiguration implements CdsRuntimeConfiguration {

  private static final Logger logger =
      LoggerFactory.getLogger(CloudFoundryEnvironmentConfiguration.class);

  @Override
  public void environment(CdsRuntimeConfigurer configurer) {
    if (System.getenv(VcapApplicationParser.VCAP_APPLICATION) != null) {
      logger.info("Loaded feature 'Cloud Foundry Platform Environment'");
      configurer.environment(new CloudFoundryApplicationInfoProvider());
    }
  }
}
