/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.em.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sap.cds.feature.messaging.em.client.EnterpriseMessagingOAuth2PropertySupplier;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClient;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClientResponseException;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class EnterpriseMessagingManagementClient
extends JsonRestClient {
    private static final String API_BASE = "/hub/rest/api/v1/management/messaging";
    private static final String API_QUEUES = "/hub/rest/api/v1/management/messaging/queues";
    private static final String API_CREATE_QUEUE = "/hub/rest/api/v1/management/messaging/queues/%s";
    private static final String API_SUBSCRIPTIONS = "/hub/rest/api/v1/management/messaging/queues/%s/subscriptions";
    private static final String API_SUBSCRIBE = "/hub/rest/api/v1/management/messaging/queues/%s/subscriptions/%s";
    private static final String API_READYNESS = "/hub/rest/api/v1/management/messaging/readinessCheck";

    public EnterpriseMessagingManagementClient(ServiceBinding binding) {
        super(ServiceBindingDestinationOptions.forService((ServiceBinding)binding).onBehalfOf(OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT).withOption((ServiceBindingDestinationOptions.OptionsEnhancer)EnterpriseMessagingOAuth2PropertySupplier.EnterpriseMessagingOptions.MANAGEMENT_API).build());
    }

    public void removeQueue(String name) throws IOException {
        String encName = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        this.deleteRequest(API_CREATE_QUEUE.formatted(encName));
    }

    public void createQueue(String name, Map<String, Object> properties) throws IOException {
        ObjectNode data = (ObjectNode)this.mapper.convertValue(properties, ObjectNode.class);
        String encName = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        this.putRequest(API_CREATE_QUEUE.formatted(encName), (JsonNode)data);
    }

    public ArrayNode getQueues() throws IOException {
        return (ArrayNode)this.getRequest(API_QUEUES);
    }

    public JsonNode getQueue(String queue) throws IOException {
        try {
            String encName = URLEncoder.encode(queue, StandardCharsets.UTF_8.toString());
            return this.getRequest(API_CREATE_QUEUE.formatted(encName));
        }
        catch (JsonRestClientResponseException e) {
            if (e.getResponseCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public void createQueueSubscription(String queue, String topic) throws IOException {
        ObjectNode data = this.mapper.createObjectNode();
        data.put("maxQueueSizeInBytes", "0");
        String encQueue = URLEncoder.encode(queue, StandardCharsets.UTF_8.toString());
        String encTopic = URLEncoder.encode(topic, StandardCharsets.UTF_8.toString());
        this.putRequest(API_SUBSCRIBE.formatted(encQueue, encTopic), null);
    }

    public ArrayNode getQueueSubscriptions(String queue) throws IOException {
        try {
            String encName = URLEncoder.encode(queue, StandardCharsets.UTF_8.toString());
            return (ArrayNode)this.getRequest(API_SUBSCRIPTIONS.formatted(encName));
        }
        catch (JsonRestClientResponseException e) {
            if (e.getResponseCode() == 404) {
                return this.mapper.createArrayNode();
            }
            throw e;
        }
    }

    public boolean checkTenantInstanceReadiness() throws IOException {
        int resp = this.getRequestWithOnlyResponseCode(API_READYNESS);
        switch (resp) {
            case 200: {
                return true;
            }
            case 503: {
                return false;
            }
        }
        throw new IOException("The tenant readiness check failed with status code " + resp);
    }

    static {
        EnterpriseMessagingOAuth2PropertySupplier.initialize();
    }
}

