/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.em.client;

import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.TypedMapView;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import io.vavr.control.Option;
import java.net.URI;
import javax.annotation.Nonnull;

public class EnterpriseMessagingOAuth2PropertySupplier
extends DefaultOAuth2PropertySupplier {
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            OAuth2ServiceBindingDestinationLoader.registerPropertySupplier(options -> ServiceBindingUtils.matches((ServiceBinding)options.getServiceBinding(), (String)"enterprise-messaging"), EnterpriseMessagingOAuth2PropertySupplier::new);
            initialized = true;
        }
    }

    public EnterpriseMessagingOAuth2PropertySupplier(ServiceBindingDestinationOptions options) {
        super(options);
    }

    public URI getServiceUri() {
        Option maybeOption = this.options.getOption(EnterpriseMessagingOptions.class);
        if (maybeOption.isEmpty()) {
            throw new DestinationAccessException("No option given for which Enterprise Messaging API should be used. Please include an option " + EnterpriseMessagingOptions.class.getName() + " in the service binding destination options.");
        }
        EnterpriseMessagingOptions option = (EnterpriseMessagingOptions)((Object)maybeOption.get());
        switch (option) {
            case MANAGEMENT_API: {
                return URI.create(this.credentials.getListView("management").getMapView(0).getString("uri"));
            }
            case WEBHOOK_MANAGEMENT_API: {
                return this.credentials.getListView("messaging").getItems(TypedMapView.class).stream().filter(c -> c.getListView("protocol").getString(0).equals("httprest")).map(c -> c.getString("uri")).map(URI::create).findFirst().orElse(null);
            }
        }
        throw new IllegalStateException("Found option value " + option + " for " + EnterpriseMessagingOptions.class.getName() + ", but no URL key was registered for this value. Please ensure that for each possible choice a URL key is registered.");
    }

    public static enum EnterpriseMessagingOptions implements ServiceBindingDestinationOptions.OptionsEnhancer<EnterpriseMessagingOptions>
    {
        MANAGEMENT_API,
        WEBHOOK_MANAGEMENT_API;


        @Nonnull
        public EnterpriseMessagingOptions getValue() {
            return this;
        }
    }
}

