/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.em.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sap.cds.feature.messaging.em.client.EnterpriseMessagingOAuth2PropertySupplier;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClient;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClientResponseException;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseMessagingWebhookManagementClient
extends JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(EnterpriseMessagingWebhookManagementClient.class);
    private static final String WEBHOOKS = "/messagingrest/v1/subscriptions";
    private static final String TOPICS = "/messagingrest/v1/topics/{topic}/messages";
    private static final String OAUTH_PATH = "/oauth/token";
    private final String name;
    private final Map<String, Object> uaaCredentials;

    public EnterpriseMessagingWebhookManagementClient(ServiceBinding binding, CdsProperties.ConnectionPool connectionPoolConfig) {
        super(ServiceBindingDestinationOptions.forService((ServiceBinding)binding).onBehalfOf(OnBehalfOf.TECHNICAL_USER_CURRENT_TENANT).withOption((ServiceBindingDestinationOptions.OptionsEnhancer)EnterpriseMessagingOAuth2PropertySupplier.EnterpriseMessagingOptions.WEBHOOK_MANAGEMENT_API).build(), connectionPoolConfig);
        this.name = (String)binding.getName().get();
        this.uaaCredentials = (Map)binding.getCredentials().get("uaa");
    }

    public void sendMessage(String topic, String message) throws IOException {
        logger.debug("Sending message from client '{}' to topic '{}'", (Object)this.name, (Object)topic);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain");
        headers.put("x-qos", "0");
        this.postRequest(TOPICS.replace("{topic}", URLEncoder.encode(topic, StandardCharsets.UTF_8.toString())), message, headers);
    }

    public ArrayNode getRegisteredWebhooks() throws IOException {
        logger.debug("Retrieving all registered webhooks of service binding '{}'", (Object)this.name);
        return (ArrayNode)this.getRequest(WEBHOOKS);
    }

    public boolean deleteWebhookRegistration(String webhookName) throws IOException {
        logger.info("Deleting webhook for service '{}' of service binding '{}'", (Object)webhookName, (Object)this.name);
        try {
            this.deleteRequest("/messagingrest/v1/subscriptions/" + webhookName);
        }
        catch (JsonRestClientResponseException e) {
            if (e.getResponseCode() == 404) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public void createOrUpdateWebhookRegistration(String webhookName, String queue, String hookUrl, String tenantSubdomain) throws IOException {
        this.deleteWebhookRegistration(webhookName);
        logger.info("Creating webhook for service '{}' at URL '{}' for queue '{}' on service binding '{}'", new Object[]{webhookName, hookUrl, queue, this.name});
        ObjectNode data = this.mapper.createObjectNode();
        data.put("name", webhookName);
        data.put("address", "queue:" + queue);
        data.put("qos", 1);
        ObjectNode pushConfig = this.mapper.createObjectNode();
        data.set("pushConfig", (JsonNode)pushConfig);
        pushConfig.put("type", "webhook");
        pushConfig.put("endpoint", hookUrl);
        pushConfig.put("exemptHandshake", true);
        this.addSecuritySchema(pushConfig, tenantSubdomain);
        this.postRequest(WEBHOOKS, (JsonNode)data);
    }

    private String replaceSubdomain(String url, String subdomain) {
        if (subdomain != null) {
            url = url.replaceFirst("://[^\\.]*\\.", "://" + subdomain + ".");
        }
        return url;
    }

    private void addSecuritySchema(ObjectNode config, String tenantSubdomain) {
        ObjectNode securitySchema = this.mapper.createObjectNode();
        config.set("securitySchema", (JsonNode)securitySchema);
        securitySchema.put("grantType", "client_credentials");
        securitySchema.put("clientId", (String)this.uaaCredentials.get("clientid"));
        if ("x509".equals(this.uaaCredentials.get("credential-type"))) {
            securitySchema.put("tokenUrl", this.replaceSubdomain((String)this.uaaCredentials.get("certurl"), tenantSubdomain) + OAUTH_PATH);
            securitySchema.put("type", "oauth2-x509");
            securitySchema.put("certificate", (String)this.uaaCredentials.get("certificate"));
            securitySchema.put("key", (String)this.uaaCredentials.get("key"));
        } else {
            securitySchema.put("tokenUrl", this.replaceSubdomain((String)this.uaaCredentials.get("url"), tenantSubdomain) + OAUTH_PATH);
            securitySchema.put("type", "oauth2");
            securitySchema.put("clientSecret", (String)this.uaaCredentials.get("clientsecret"));
        }
    }

    static {
        EnterpriseMessagingOAuth2PropertySupplier.initialize();
    }
}

