/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.messaging.em.mt.webhook;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.io.CharStreams;
import com.sap.cds.feature.messaging.em.mt.service.EnterpriseMessagingMtService;
import com.sap.cds.feature.messaging.em.mt.service.EnterpriseMessagingTenantStatus;
import com.sap.cds.impl.util.Pair;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.messaging.service.MessagingBrokerQueueListener;
import com.sap.cds.services.messaging.utils.MessagingUtils;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseMessagingWebhookAdapter
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(EnterpriseMessagingWebhookAdapter.class);
    private static final String HEADER_HANDSHAKE_FROM = "webhook-request-origin";
    private static final String HEADER_HANDSHAKE_TO = "webhook-allowed-origin";
    private static final String HEADER_QUEUE = "x-queue";
    private static final String HEADER_TOPIC = "x-address";
    private static final String ROLE_EMCALLBACK = "emcallback";
    private static final String ROLE_EMMANAGEMENT = "emmanagement";
    private static final String UNEXPECTED_ERROR_OCCURRED_MESSAGE = "An unexpected error occurred during servlet processing";
    private final CdsRuntime runtime;
    private final Map<String, MessagingBrokerQueueListener> queueListeners = new HashMap<String, MessagingBrokerQueueListener>();
    private final TenantProviderService tenantService;
    private final JsonMapper mapper = new JsonMapper();

    public EnterpriseMessagingWebhookAdapter(CdsRuntime runtime) {
        this.runtime = runtime;
        runtime.getServiceCatalog().getServices(MessagingService.class).map(OutboxService::unboxed).filter(EnterpriseMessagingMtService.class::isInstance).map(EnterpriseMessagingMtService.class::cast).forEach(service -> {
            MessagingBrokerQueueListener listener = service.getQueueListener();
            this.queueListeners.put(listener.getQueueName(), listener);
            logger.info("Registered webhook queue listener for '{}'", (Object)listener.getQueueName());
        });
        this.tenantService = (TenantProviderService)runtime.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.runInRequestContext(req, resp, requestContext -> {
            this.checkRole(ROLE_EMMANAGEMENT);
            String tenantId = this.getUrlParameterTenantId(req);
            boolean verbose = Boolean.parseBoolean(req.getParameter("verbose"));
            if (tenantId != null) {
                this.runtime.requestContext().systemUser(tenantId).run(tenantRequestContext -> this.writeJsonResponse(req, resp, this.getTenantStatus(tenantId, verbose)));
            } else {
                ArrayList tenants = new ArrayList();
                this.tenantService.readTenants().forEach(tenant -> this.runtime.requestContext().systemUser(tenant).run(tenantRequestContext -> tenants.add(this.getTenantStatus((String)tenant, verbose))));
                this.writeJsonResponse(req, resp, tenants);
            }
        });
    }

    private EnterpriseMessagingTenantStatus getTenantStatus(String tenantId, boolean verbose) {
        List<EnterpriseMessagingTenantStatus> statuses = this.runtime.getServiceCatalog().getServices(MessagingService.class).map(OutboxService::unboxed).filter(EnterpriseMessagingMtService.class::isInstance).map(EnterpriseMessagingMtService.class::cast).map(s -> s.getTenantStatus(tenantId, verbose)).toList();
        EnterpriseMessagingTenantStatus merged = new EnterpriseMessagingTenantStatus(tenantId);
        for (EnterpriseMessagingTenantStatus status : statuses) {
            merged.getServices().putAll(status.getServices());
            merged.getUnmanagedQueues().addAll(status.getUnmanagedQueues());
            merged.getUnmanagedWebhooks().addAll(status.getUnmanagedWebhooks());
        }
        merged.getServices().values().forEach(s -> merged.getUnmanagedQueues().remove(s.getQueue()));
        merged.getServices().values().forEach(s -> s.getWebhooks().forEach(w -> merged.getUnmanagedWebhooks().remove(w)));
        return merged;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.runWithoutRequestContext(req, resp, () -> {
            this.checkRole(ROLE_EMCALLBACK);
            Message message = new Message(req, this.runtime.getProvidedUserInfo().getTenant());
            MessagingBrokerQueueListener listener = this.queueListeners.get(message.getBrokerQueue());
            if (listener == null) {
                throw new ServiceException((ErrorStatus)ErrorStatuses.NOT_FOUND, "Received webhook request on unknown queue '{}' with topic '{}' and ID '{}'", new Object[]{message.getBrokerQueue(), message.getBrokerTopic(), message.getId()});
            }
            try {
                listener.receivedMessage((MessagingBrokerQueueListener.MessageAccess)message);
                resp.setStatus(202);
            }
            catch (ServiceException exp) {
                if (message.isAcknowledged()) {
                    logger.debug("Ignored the exception as accepted by the error handler", (Throwable)exp);
                    resp.setStatus(202);
                }
                throw exp;
            }
        });
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.runInRequestContext(req, resp, requestContext -> {
            this.checkRole(ROLE_EMCALLBACK);
            String origin = req.getHeader(HEADER_HANDSHAKE_FROM);
            if (origin == null) {
                throw new ServiceException((ErrorStatus)ErrorStatuses.BAD_REQUEST, "Received invalid webhook handshake without origin", new Object[0]);
            }
            resp.setHeader(HEADER_HANDSHAKE_TO, origin);
            logger.info("Webhook registration handshake with origin '{}' received", (Object)origin);
            resp.setStatus(202);
        });
    }

    private void runInRequestContext(HttpServletRequest req, HttpServletResponse resp, Consumer<RequestContext> consumer) throws IOException {
        this.runWithoutRequestContext(req, resp, () -> this.runtime.requestContext().systemUserProvider().run(consumer));
    }

    private void runWithoutRequestContext(HttpServletRequest req, HttpServletResponse resp, Runnable action) throws IOException {
        Locale locale = this.runtime.getProvidedParameterInfo().getLocale();
        try {
            action.run();
        }
        catch (ServiceException e) {
            int httpStatus = e.getErrorStatus().getHttpStatus();
            if (httpStatus >= 500 && httpStatus < 600) {
                logger.error(UNEXPECTED_ERROR_OCCURRED_MESSAGE, (Throwable)e);
            } else {
                logger.debug(UNEXPECTED_ERROR_OCCURRED_MESSAGE, (Throwable)e);
            }
            this.writeErrorResponse(req, resp, httpStatus, e.getLocalizedMessage(locale));
        }
        catch (Exception e) {
            logger.error(UNEXPECTED_ERROR_OCCURRED_MESSAGE, (Throwable)e);
            this.writeErrorResponse(req, resp, 500, new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(locale));
        }
    }

    private void checkRole(String role) {
        if (!this.runtime.getProvidedUserInfo().hasRole(role)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_ADMIN_FORBIDDEN, new Object[0]);
        }
    }

    private String getUrlParameterTenantId(HttpServletRequest req) {
        String[] pathParameters = StringUtils.trim((String)req.getPathInfo(), (char)'/').split("/");
        return pathParameters.length > 0 ? (StringUtils.isEmpty((String)pathParameters[0]) ? null : pathParameters[0]) : null;
    }

    private void writeJsonResponse(HttpServletRequest req, HttpServletResponse resp, Object content) {
        resp.setContentType("application/json");
        try {
            PrintWriter out = resp.getWriter();
            this.mapper.writeValue((Writer)out, content);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeErrorResponse(HttpServletRequest req, HttpServletResponse resp, int httpStatus, String message) throws IOException {
        String responseContent = "{\"error\":{\"code\":\"" + httpStatus + "\",\"message\":\"" + message + "\"}}";
        resp.setStatus(httpStatus);
        resp.setContentType("application/json");
        resp.getWriter().println(responseContent);
    }

    private static class Message
    implements MessagingBrokerQueueListener.MessageAccess {
        private String id;
        private final String queue;
        private final String topic;
        private final String message;
        private final String tenant;
        private volatile boolean acknowledged;
        private Map<String, Object> dataMap;
        private Map<String, Object> headersMap;

        public Message(HttpServletRequest req, String tenant) {
            String theQueue = req.getHeader(EnterpriseMessagingWebhookAdapter.HEADER_QUEUE);
            if (theQueue != null) {
                theQueue = theQueue.trim();
            }
            this.queue = theQueue;
            this.tenant = tenant;
            String theTopic = req.getHeader(EnterpriseMessagingWebhookAdapter.HEADER_TOPIC);
            if (theTopic != null) {
                if ((theTopic = theTopic.trim()).startsWith("topic:")) {
                    theTopic = theTopic.substring(6).trim();
                }
            } else {
                theTopic = this.queue;
            }
            this.topic = theTopic;
            logger.debug("Received webhook request from queue '{}' on topic '{}' with ID '{}'", new Object[]{this.queue, this.topic, this.id});
            try (InputStreamReader reader = new InputStreamReader((InputStream)req.getInputStream(), StandardCharsets.UTF_8);){
                this.message = CharStreams.toString((Readable)reader);
            }
            catch (IOException e) {
                throw new ServiceException("Failed to read body of webhook request for queue '{}'", new Object[]{this.queue, e});
            }
        }

        public String getId() {
            return this.id;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, Object> getDataMap() {
            if (this.dataMap == null) {
                this.populateMaps();
            }
            return this.dataMap;
        }

        public Map<String, Object> getHeadersMap() {
            if (this.headersMap == null) {
                this.populateMaps();
            }
            return this.headersMap;
        }

        private void populateMaps() {
            Pair maps = MessagingUtils.toStructuredMessage((String)this.message);
            this.dataMap = (Map)maps.left;
            this.headersMap = (Map)maps.right;
        }

        public String getBrokerQueue() {
            return this.queue;
        }

        public String getBrokerTopic() {
            return this.topic;
        }

        public void acknowledge() {
            this.acknowledged = true;
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }
    }
}

